---
name: adaptive-learning-companion
version: 1.0.0
description: AI tutor that diagnoses why you're stuck and adapts explanations until concepts click
author: FindSkill.ai
license: MIT
---

# Initialization

An adaptive AI tutoring companion that goes beyond simple explanations. This skill diagnoses WHY learners get stuck, identifies misconceptions, adapts teaching style based on what works, and verifies true understanding through active testing.

## What Makes This Different

| Standard Tutoring | Adaptive Learning Companion |
|-------------------|----------------------------|
| Explains when asked | Diagnoses before explaining |
| One explanation style | Multiple styles until one clicks |
| Assumes understanding | Actively verifies comprehension |
| Same approach for everyone | Tracks what works for YOU |

## Structure

This is a prompt-only skill:

```
adaptive-learning-companion/
├── SKILL.md    # Main skill prompt
└── INIT.md     # This file
```

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r adaptive-learning-companion/ ~/.claude/skills/adaptive-learning-companion/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `subject` | (empty) | The topic or subject you want to learn |
| `current_level` | beginner | Your current knowledge level |

## Key Features

### 1. Diagnostic Assessment
The skill starts by asking probing questions to understand:
- Your current mental model of the topic
- What specific aspects are confusing
- What related concepts you already understand
- What misconceptions might be blocking you

### 2. Adaptive Explanation Styles
Based on your responses, the skill tries different approaches:
- Analogy-based explanations
- Visual/spatial descriptions
- Step-by-step processes
- Concrete examples first
- Contrast/comparison with known concepts
- Building from simple to complex

### 3. Comprehension Verification
After explaining, the skill actively checks understanding:
- Explain-back tests
- Prediction tests
- Application tests
- Edge case tests

### 4. Learning Obstacle Handling
Special approaches for common blocks:
- "I understand but can't do it myself" → Scaffolded practice
- "I keep making the same mistake" → Misconception identification
- "I get the pieces but not the whole" → Big-picture framework
- "It's too abstract" → Concrete grounding
- "I'm overwhelmed" → Simplification

## Best Used For

- Complex technical concepts (programming, math, science)
- Topics you've tried to learn before but didn't stick
- Abstract concepts that are hard to visualize
- Building deep understanding vs. surface familiarity
- Self-directed learning without a human tutor

## Example Interaction

**User**: I'm trying to understand recursion in programming. I've read about it but it doesn't click.

**Skill Response**:
1. Asks diagnostic questions about what specifically is confusing
2. Identifies the user already understands loops (prerequisite check)
3. Tries an analogy-based explanation (Russian nesting dolls)
4. If that doesn't work, switches to step-by-step code tracing
5. Asks the user to predict what a simple recursive function returns
6. Addresses any remaining confusion with a different angle

---
Downloaded from [Find Skill.ai](https://findskill.ai)
