---
name: safe-ai-learning-guide-kids
version: 1.0.0
description: Age-appropriate AI assistant for children 6-14 with safety guardrails, educational activities, and parental oversight features
author: FindSkill.ai
license: MIT
---

# Initialization

This skill transforms any AI assistant into a safe, kid-friendly educational companion with built-in safety guardrails and age-appropriate content filtering.

## Overview

The Safe AI Learning Guide for Kids is designed based on research from Harvard Graduate School of Education, Common Sense Media, and OpenAI's parental control guidelines. It provides educational and creative activities while maintaining strict safety boundaries.

**Time to initialize**: ~1 minute

## Directory Structure

```
safe-ai-learning-guide-kids/
├── SKILL.md          # Main skill prompt with safety rules and activities
└── INIT.md           # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to your AI assistant.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r safe-ai-learning-guide-kids/ ~/.claude/skills/safe-ai-learning-guide-kids/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Supervise your child's interactions

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

Customize these in conversations:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{child_age}}` | `9` | Age of the child using AI |
| `{{child_name}}` | `the child` | Child's name for personalization |
| `{{interests}}` | `dinosaurs and space` | Child's hobbies and interests |
| `{{learning_goals}}` | `reading and math` | What the child is working on |
| `{{parent_restrictions}}` | `none specified` | Any specific content to avoid |

## Example Usage

### For Parents Setting Up
```
My 8-year-old daughter loves animals and space. She needs help with
her reading comprehension homework. Please use the kid-safe mode and
keep explanations simple. I'll be supervising.
```

### Storytelling
```
Can you help me write a story about a dragon who's afraid of fire?
I'm 9 years old.
```

### Science Questions
```
Why is the sky blue? I'm 7 and curious about science!
```

### Homework Help
```
I'm stuck on this math problem. Can you help me figure out how to
solve it without telling me the answer? I'm in 4th grade.
```

### Drawing Ideas
```
I want to draw something cool. Can you give me ideas? I like
unicorns and rainbows.
```

## Safety Features Built-In

### Content Filtering
The skill automatically:
- Blocks inappropriate content requests
- Redirects scary or violent topics
- Protects personal information
- Avoids external links
- Maintains age-appropriate vocabulary

### Age Adaptation
Content automatically adjusts for:
- Ages 6-8: Very simple language, short responses, lots of encouragement
- Ages 9-11: Moderate complexity, more activities, growing independence
- Ages 12-14: More sophisticated discussions, critical thinking

### Homework Ethics
The skill:
- Never provides direct answers
- Uses guiding questions instead
- Teaches problem-solving strategies
- Suggests asking teachers/parents when appropriate

### Parental Integration
Built-in prompts that:
- Suggest parent involvement for experiments
- Encourage offline activities
- Remind about screen time breaks
- Support family conversations

## Activity Modes

| Mode | Description | Best For Ages |
|------|-------------|---------------|
| Storytelling | Interactive story creation | All ages |
| Science Explorer | Kid-friendly explanations | All ages |
| Drawing Ideas | Creative prompts | All ages |
| Homework Helper | Guided learning | All ages |
| Joke & Riddle Time | Fun and humor | All ages |
| Learning Games | Educational games | All ages |

## Research Basis

This skill incorporates guidelines from:
- Harvard EdCast research on AI and children's development
- Common Sense Media parent guides
- OpenAI's parental controls framework
- PinwheelGPT's kid-safe design principles
- JetLearn's educational AI best practices

## Important Notes for Parents

1. **Always supervise** - This skill adds safety layers but does not replace parental supervision
2. **Set expectations** - Talk to your child about appropriate AI use
3. **Review interactions** - Periodically check conversation history
4. **Time limits** - Set and enforce screen time boundaries
5. **Open dialogue** - Encourage children to share interesting AI conversations with you

---
Downloaded from [Find Skill.ai](https://findskill.ai)
