---
name: small-business-ai-operations-coach
version: 1.0.0
description: Guide small business owners through implementing AI for customer service, email automation, social media management, and data analytics
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill transforms you into a Small Business AI Operations Coach, helping entrepreneurs and small business owners (1-50 employees) implement practical AI solutions across four key areas:

1. **Customer Service Automation** - Chatbots, live chat, automated responses
2. **Email Marketing Automation** - Sequences, campaigns, personalization
3. **Social Media Management** - Content scheduling, AI content generation
4. **Business Analytics** - KPI tracking, dashboards, insights

The skill includes:
- AI Readiness Assessment framework
- Tool recommendations by budget tier ($0-50, $50-150, $150-300/month)
- Industry-specific guidance (service, retail, professional, hospitality)
- Crawl-Walk-Run implementation methodology
- ROI calculation templates

**Time to initialize**: ~1 minute (prompt-only skill)

## Directory Structure

```
small-business-ai-operations-coach/
├── SKILL.md              # Main skill instructions and knowledge base
└── INIT.md               # This initialization manifest
```

## Dependencies

None required - this is a prompt-only skill.

## Files to Generate

This is a **prompt-only skill** with no additional scripts or files to generate. The SKILL.md file contains all necessary instructions, frameworks, and knowledge.

## Installation Methods

### Method 1: Claude Code (Recommended)

```bash
# Create skill directory
mkdir -p ~/.claude/skills/small-business-ai-operations-coach

# Copy files to skill directory
cp SKILL.md ~/.claude/skills/small-business-ai-operations-coach/
cp INIT.md ~/.claude/skills/small-business-ai-operations-coach/
```

After installation, the skill will be available in Claude Code sessions.

### Method 2: Direct Use in Any AI Assistant

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Begin your session with an AI readiness assessment

### Method 3: Custom Instructions (ChatGPT, Claude Projects)

1. Open `SKILL.md`
2. Copy the content
3. Add to Custom Instructions or Project Knowledge
4. The AI will use this as background knowledge for all conversations

## Quick Start Guide

### For Claude Code Users

After installation, start a session by mentioning small business AI operations:

```
Help me implement AI for my small business
```

The skill will automatically:
1. Conduct an AI readiness assessment
2. Identify priority areas based on your pain points
3. Recommend tools within your budget
4. Create a phased implementation plan

### For Other AI Assistants

Paste the SKILL.md content and then describe your business:

```
I run a [business type] with [X] employees. Our biggest challenge is [pain point].
Our budget for new tools is around $[amount]/month.
```

## Skill Capabilities

### AI Readiness Assessment
Evaluates business on:
- Current technology stack
- Time availability for implementation
- Budget constraints
- Pain point clarity
- Technology comfort level

Produces a readiness score (1-10) with recommendations.

### Tool Recommendations

**By Budget:**
- Shoestring ($0-50/month): Free tiers of Tidio, MailerLite, Buffer
- Growing ($50-150/month): Tidio AI, Brevo, SocialBee, Databox
- Investment ($150-300/month): Intercom, ActiveCampaign, Hootsuite

**By Business Type:**
- Service businesses: Focus on chat + appointment booking
- E-commerce: Focus on abandoned cart + product emails
- Professional services: Focus on lead qualification + drip campaigns
- Hospitality: Focus on reservations + review management

### Implementation Methodology

**Crawl (Weeks 1-4):**
- Single tool, single use case
- Basic setup (2-4 hours)
- Document learnings

**Walk (Weeks 5-12):**
- Optimize based on data
- Add second AI area
- Integrate tools

**Run (Months 4-6+):**
- All four pillars active
- Cross-tool automation
- Continuous optimization

### ROI Calculation

Templates for calculating:
- Time savings value
- Lead/revenue impact
- Break-even analysis
- Monthly net benefit

## Variables

Customize these in your sessions:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_type}}` | service-based business | Retail, service, e-commerce, professional services |
| `{{team_size}}` | 5-10 employees | Number of people in the business |
| `{{monthly_budget}}` | $100-300 | Available budget for AI tools |
| `{{primary_pain_point}}` | customer response times | Biggest operational challenge |
| `{{current_tools}}` | email, spreadsheets | Existing software stack |

## Compatibility

**Tested and working with:**
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- Microsoft Copilot
- Other LLMs with long context support

## Usage Examples

### Example 1: Service Business

**User:** "I run a local plumbing company with 8 employees. We're drowning in phone calls and emails, and I know we're losing customers because we can't respond fast enough. Our budget is around $200/month."

**AI will:**
1. Assess readiness (likely medium-high)
2. Prioritize customer service automation
3. Recommend Tidio AI ($29/mo) for chat/SMS
4. Suggest email automation with Brevo ($16/mo)
5. Create 4-week implementation plan

### Example 2: E-commerce Store

**User:** "I have an online boutique selling handmade jewelry. I do everything myself. Sales are inconsistent and I spend hours on social media with little return."

**AI will:**
1. Assess as solopreneur (specific guidance)
2. Prioritize email automation for customer retention
3. Recommend Mailchimp free tier to start
4. Suggest Buffer for social media scheduling
5. Focus on abandoned cart recovery first

### Example 3: Professional Services

**User:** "I'm a financial advisor with a small team of 3. We get a lot of website inquiries but don't have time to follow up quickly."

**AI will:**
1. Assess as professional services
2. Prioritize lead qualification chatbot
3. Recommend Tidio or Intercom based on budget
4. Suggest drip email campaign for nurturing
5. Focus on compliance-friendly messaging

## Updating the Skill

To update to a newer version:

1. Download the latest SKILL.md from FindSkill.ai
2. Replace the existing file in your skills directory
3. Restart your Claude Code session

## Troubleshooting

**Skill not activating:**
- Ensure SKILL.md is in the correct directory
- Check file permissions
- Try mentioning "small business AI" explicitly

**Recommendations too generic:**
- Provide more specific business details
- Share current pain points clearly
- Specify exact budget constraints

**Tool recommendations outdated:**
- Check for skill updates
- Verify tool pricing on official websites
- AI knowledge may not include latest pricing

## Support

For questions or updates:
- Website: https://findskill.ai
- Skill page: https://findskill.ai/skills/small-business-ai-operations-coach/

---

Downloaded from [Find Skill.ai](https://findskill.ai)
