---
name: 2026-holiday-greetings-generator
version: 1.0.0
---

# Initialization

Transform the mental load of holiday messaging into personalized, culturally intelligent greetings for any recipient — from your CEO to your Gen Z nephew.

## What This Skill Does

The **2026 Holiday Greetings Generator** is a "Social Signaling Optimization Engine" that:

1. **Reduces Mental Load**: Generate 50+ unique messages for different relationship tiers without writer's block
2. **Prevents Tone Deafness**: Strictly gates content based on relationship context (no accidentally sending memes to your boss)
3. **Provides Cultural Intelligence**: Moves beyond generic "Happy Holidays" to include specific, culturally accurate well-wishes

## Structure

```
2026-holiday-greetings-generator/
├── SKILL.md          # Main skill prompt (paste into AI assistant)
├── INIT.md           # This initialization file
└── index.md          # Website listing metadata
```

## Files to Generate

None (prompt-only skill)

## How to Use

### Claude Code
```bash
cp -r 2026-holiday-greetings-generator/ ~/.claude/skills/2026-holiday-greetings-generator/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or conversation

### Quick Start
After loading the skill, simply describe your situation:

```
"I need to send holiday messages to:
- My CEO (we've met twice)
- My work bestie Sarah (just got promoted)
- My Gen Z nephew (only speaks in memes)
- My grandmother (first Christmas without grandpa)

Make them feel personal, not generic."
```

## Key Features

### 5 Writer Personas
| Persona | Tone Range | Best For |
|---------|------------|----------|
| Corporate Polish | 1-4 | Bosses, clients, LinkedIn |
| Warm Professional | 5-6 | Work friends, vendors |
| Chaotic Good | 7-9 | Best friends, siblings |
| Gen Z Brainrot | 8-10 | TikTok, meme-only friends |
| Stoic Realist | Variable | Intellectual friends, hard year |

### Cultural Intelligence
Authentic greetings for:
- Western secular
- Christian (Christmas)
- Jewish (Hanukkah)
- Chinese/Lunar New Year
- German (Guten Rutsch)
- Spanish (Feliz Navidad)
- Japanese (New Year)
- Italian, Korean, and more

### Etiquette Guardrails
- **Grief Protocol**: Automatically adjusts tone for recipients experiencing loss
- **Boss Boundary**: Keeps professional messages appropriately formal
- **Ex Protocol**: Generates safe, non-committal messages
- **Reconnection Mode**: Handles "haven't spoken in a while" gracefully

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{recipient_type}}` | `colleague` | Relationship tier (boss, friend, family, etc.) |
| `{{tone}}` | `professional` | Tone from formal (1) to chaotic (10) |
| `{{cultural_context}}` | `secular-western` | Cultural/religious context |
| `{{relationship_depth}}` | `3` | Closeness scale 1-5 |
| `{{format}}` | `text message` | Output format (text, email, card, social) |
| `{{special_circumstances}}` | `none` | Grief, difficult year, reconnection, etc. |

## Output Formats Supported

- **Text Message**: Under 160 characters
- **Email**: With subject line
- **Holiday Card**: Longer, more formal
- **Social Media Caption**: With optional hashtags
- **LinkedIn Message**: Professional networking tone
- **Out of Office**: Humorous auto-reply

## Example Outputs

### Corporate (Tone 2)
> "Wishing you a restful break and a prosperous 2026. Thank you for your continued partnership."

### Chaotic Good (Tone 8)
> "May your 2026 be filled with correct password attempts on the first try."

### Gen Z (Tone 9)
> "new year entering my villain era fr. no cap 2026 finna be a movie 🚡"

### Grief-Aware
> "Thinking of you during this season. No pressure to respond — just wanted you to know you're on my mind."

## Batch Processing

For users with many recipients, the skill offers batch mode:

1. Create a recipient list with relationship, tone, and notes
2. Generate all messages in sequence
3. Get easy copy-paste formatted output

## Post-Init Verification

After loading, test with:
```
"Generate a holiday text for my boss (met 3 times, formal)"
```

Expected: Professional, brief, no emojis, forward-looking statement.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
