---
name: ai-art-prompt-crafter
version: 1.0.0
description: Master AI image generation with comprehensive prompt crafting for Midjourney, DALL-E, and Stable Diffusion
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides comprehensive guidance for crafting effective prompts for AI image generators including Midjourney, DALL-E 3, and Stable Diffusion. It includes extensive reference material for art styles, lighting techniques, composition principles, and platform-specific syntax.

**Time to initialize**: ~1 minute

## Directory Structure

```
ai-art-prompt-crafter/
├── SKILL.md          # Main skill instructions
└── INIT.md           # This initialization file
```

## Dependencies

None - this is a prompt-only skill with no external dependencies.

## Files to Generate

None - this skill consists only of the SKILL.md prompt file.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r ai-art-prompt-crafter/ ~/.claude/skills/ai-art-prompt-crafter/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- GitHub Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{platform}}` | `midjourney` | Target AI image generator |
| `{{art_style}}` | `photorealistic` | Desired artistic style |
| `{{subject}}` | (empty) | Main subject of the image |
| `{{mood}}` | `cinematic` | Emotional tone or atmosphere |
| `{{aspect_ratio}}` | `16:9` | Image dimensions ratio |

## Skill Capabilities

This skill enables you to:

1. **Craft Platform-Optimized Prompts**
   - Midjourney V6/V7 with parameters (--ar, --stylize, --sref)
   - DALL-E 3 with natural language optimization
   - Stable Diffusion with weights and negative prompts

2. **Apply Art Styles**
   - Traditional movements (Renaissance, Baroque, Impressionism)
   - Digital styles (concept art, pixel art, 3D render)
   - Photography styles (portrait, editorial, street)

3. **Reference Artists**
   - Classic masters (da Vinci, Monet, Van Gogh)
   - Contemporary digital artists (Artgerm, WLOP, Greg Rutkowski)
   - Anime/animation studios (Studio Ghibli, Makoto Shinkai)

4. **Master Lighting**
   - Natural lighting (golden hour, blue hour, backlit)
   - Studio setups (Rembrandt, high key, low key)
   - Cinematic effects (chiaroscuro, neon, volumetric)

5. **Simulate Camera Effects**
   - Focal lengths (wide, portrait, macro)
   - Depth of field and bokeh
   - Film stock emulation

6. **Apply Composition Principles**
   - Classical rules (thirds, golden ratio, symmetry)
   - Framing techniques (close-up, wide shot, Dutch angle)

## Example Outputs

### Midjourney Prompt
```
A 25-year-old cyberpunk street vendor, neon-lit rain-soaked Tokyo alley,
blade runner aesthetic, by Makoto Shinkai and Syd Mead, volumetric fog,
neon reflections on wet pavement, cinematic composition, 85mm lens,
dramatic rim lighting, highly detailed, 8K --ar 16:9 --v 7 --stylize 750
```

### DALL-E 3 Prompt
```
Create a highly detailed digital painting of a cyberpunk street vendor
in a neon-lit, rain-soaked Tokyo alley at night. The scene is inspired
by Blade Runner with anime influences. Include volumetric fog, neon
sign reflections on wet pavement, and dramatic rim lighting. The mood
is mysterious and cinematic. Professional concept art quality.
```

### Stable Diffusion Prompt
```
(cyberpunk street vendor:1.3), neon-lit alley, rain-soaked Tokyo,
blade runner aesthetic, (Makoto Shinkai style:1.2), volumetric fog,
(neon reflections:1.1), wet pavement, cinematic composition,
(dramatic rim lighting:1.2), masterpiece, best quality, 8K,
highly detailed, sharp focus

Negative: low quality, blurry, artifacts, watermark, text,
bad anatomy, distorted, amateur
```

## Research Sources

This skill was built using research from:

- [Midjourney Official Documentation](https://docs.midjourney.com/)
- [MidJourney Styles and Keywords Reference (GitHub)](https://github.com/willwulfken/MidJourney-Styles-and-Keywords-Reference)
- [Stable Diffusion Prompt Guide](https://stable-diffusion-art.com/prompt-guide/)
- [OpenAI DALL-E Documentation](https://platform.openai.com/docs/guides/images)
- [PromptHero Community Database](https://prompthero.com/)

---
Downloaded from [FindSkill.ai](https://findskill.ai)
