---
name: ai-coloring-page-creator
version: 1.0.0
description: Create custom coloring pages and coloring books with AI tools
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive coloring page creation system using AI image generators. Covers 7 styles (classic, mandala, stained glass, zentangle, geometric, kawaii, adult), theme collections, tool-specific prompts for Midjourney/DALL-E/Stable Diffusion, post-processing for print, and Amazon KDP publishing guidance.

**Time to initialize**: ~3 minutes

## Directory Structure

```
ai-coloring-page-creator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Midjourney, DALL-E, Stable Diffusion, ChatGPT, and dedicated coloring page generators (ColorBliss, Colorify AI, iColoring AI).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Choose your subject/theme and target audience (age range)
2. Select a coloring page style from the 7 options
3. Use the tool-specific prompts for your AI generator
4. Post-process output for clean black & white line art
5. Set correct DPI (300+) and page size for printing
6. For coloring books, plan 30-50 themed pages with progressive difficulty

### Key Principles

- Always include "no color, no shading, no gray" in prompts
- Thick outlines for children (ages 2-8), fine lines for adults
- Post-process with threshold filter for pure B&W output
- Use consistent prompt structure across all pages for style uniformity
- Test print before publishing — screen and paper look different

## Compatibility

Tested with: All AI assistants + Midjourney, DALL-E, Stable Diffusion, ChatGPT, ColorBliss, Colorify AI, and other coloring page generators.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{subject}}` | `a magical unicorn in an enchanted forest` | What to draw |
| `{{style}}` | `children's coloring book with thick outlines` | Style |
| `{{complexity}}` | `medium — suitable for ages 6-10` | Detail level |
| `{{page_count}}` | `5 pages` | Number of pages |
| `{{ai_tool}}` | `Midjourney` | AI tool used |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
