---
name: ai-meme-generator
version: 1.0.0
description: Create viral-worthy memes with AI — meme formats, humor techniques, and prompt engineering
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive meme creation framework covering classic and modern meme formats, humor psychology, platform-specific optimization, and AI image prompt templates for custom meme visuals.

**Time to initialize**: ~5 minutes

## Directory Structure

```
ai-meme-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: ChatGPT/DALL-E, Midjourney, Stable Diffusion, Canva, and meme editors.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Choose your topic and target audience
2. Select a meme format using the selection matrix
3. Craft your caption using the humor formulas
4. Generate a custom visual with AI or use a classic template
5. Optimize dimensions for your posting platform

### Key Principles

- The best memes are relatable first, clever second
- Keep captions short — if it needs more than 2 lines, simplify
- Match format to message (Drake for preferences, Expanding Brain for escalation)
- AI-generated visuals work best for absurdist and custom scenarios
- Test with the "screenshot test" — would someone save and send this?

## Compatibility

Tested with: ChatGPT (DALL-E 3), Midjourney v6+, any AI image generator, Canva, and traditional meme editors.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{topic}}` | `working from home struggles` | What the meme is about |
| `{{audience}}` | `tech professionals on LinkedIn` | Target audience |
| `{{tone}}` | `relatable and self-deprecating` | Humor style |
| `{{format}}` | `any` | Preferred meme format |
| `{{platform}}` | `Twitter/X` | Posting platform |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
