---
name: ai-photo-editing-master
version: 1.0.0
description: Master AI photo editing with background removal, inpainting, outpainting, style transfer, upscaling, and retouching
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive AI photo editing system covering background removal, object removal, inpainting, outpainting, upscaling, face restoration, style transfer, color grading, and professional retouching workflows. Includes tool-specific guidance for Adobe Photoshop AI, Firefly, DALL-E, Midjourney, Stable Diffusion, and free/open-source alternatives.

**Time to initialize**: ~5 minutes

## Directory Structure

```
ai-photo-editing-master/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Adobe Photoshop AI, Adobe Firefly, DALL-E, Midjourney, Stable Diffusion, IOPaint, GFPGAN, Real-ESRGAN, Remove.bg, Photoroom, Canva, and any AI assistant.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Identify the type of edit needed (removal, generation, enhancement, transformation)
2. Use the tool selection reference to pick the best AI tool for your task
3. Follow the phase-specific workflow (background, inpainting, outpainting, etc.)
4. Apply professional retouching order for portrait/product work
5. Troubleshoot any issues using the common problems guide

### Key Principles

- Always work on a copy of the original photo
- Match lighting, color temperature, and perspective in composited edits
- Preserve natural skin texture in portrait retouching
- Upscale AFTER all other edits are complete
- Use the right tool for each task (no single AI tool does everything best)
- Subtle edits > dramatic transformations for realism

## Compatibility

Tested with: All AI assistants + Adobe Photoshop, Adobe Firefly, DALL-E, Midjourney, Stable Diffusion, IOPaint, GFPGAN, Real-ESRGAN, Remove.bg, Photoroom, Luminar AI, Topaz Suite.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{edit_type}}` | `remove an unwanted person from background` | Type of edit |
| `{{photo_description}}` | `outdoor portrait with tourists in background` | Photo description |
| `{{desired_result}}` | `clean background, natural lighting` | Desired result |
| `{{ai_tool}}` | `Adobe Firefly` | AI tool used |
| `{{quality_level}}` | `professional quality for portfolio` | Quality standard |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
