---
name: brand-visual-identity-generator
version: 1.0.0
description: Generate complete brand visual identity systems with AI — strategy, colors, typography, logo, imagery, and guidelines
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive brand visual identity creation framework covering brand strategy, color palette systems, typography hierarchies, logo direction, imagery guidelines, and brand book documentation. Designed for entrepreneurs, marketers, and designers building professional brand identities.

**Time to initialize**: ~5 minutes

## Directory Structure

```
brand-visual-identity-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Figma, Canva, Adobe Creative Suite, and AI tools (ChatGPT, Midjourney, Huemint, Fontjoy).

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define brand name, industry, and personality traits
2. Use Phase 1 to establish strategic foundation
3. Build color palette with Phase 2 framework
4. Select typography with Phase 3 hierarchy
5. Explore logo concepts with Phase 4 prompts
6. Document everything using Phase 6 brand book structure

### Key Principles

- Strategy before design — always start with positioning and personality
- Color palettes need 4 tiers: primary, secondary, neutrals, functional
- Typography needs a clear hierarchy from Display to Caption
- Logos need 3 versions: primary mark, secondary mark, favicon
- Always test color accessibility (WCAG 2.1 AA minimum)
- Document everything in brand guidelines for consistency

## Compatibility

Tested with: All AI assistants + Figma, Canva, Adobe tools, and brand management platforms.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{brand_name}}` | `Skyline Studio` | Brand name |
| `{{industry}}` | `creative design agency` | Industry type |
| `{{brand_personality}}` | `modern, innovative, approachable yet professional` | Brand personality |
| `{{target_audience}}` | `tech startups and SaaS companies` | Target audience |
| `{{competitors}}` | `Pentagram, Collins, Wolff Olins` | Competitors |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
