---
name: character-world-builder
version: 1.0.0
description: Create characters shaped by their worlds and worlds revealed through characters for fantasy, sci-fi, and speculative fiction
author: FindSkill.ai
license: MIT
---

# Initialization

Character & World Builder creates integrated character-world systems where characters are shaped by their settings and worlds are revealed through their inhabitants. The key insight: characters and worlds are inseparable.

## Overview

This is a prompt-only skill with no scripts to generate. The skill focuses on:

- Character-world integration framework
- The Holy Triangle for magic/technology systems
- Culture building with values, structure, daily life
- Geography as story driver
- Character depth through wounds, lies, and wants vs. needs
- Multiple output formats for different purposes

**Time to initialize**: ~1 minute (copy and paste)

## Directory Structure

```
character-world-builder/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - simply copy the SKILL.md content to use.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r character-world-builder/ ~/.claude/skills/character-world-builder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Quick Start Examples

### Character with World Context
```
I need a rogue character for a D&D campaign. The setting is a desert
empire that recently conquered her coastal homeland. She wants revenge
but has fallen in love with someone from the empire. Help me develop
her backstory and show how the world's politics shaped who she became.
```

### World Element Creation
```
I'm building a magic system for my novel. Magic is tied to emotions -
the stronger you feel, the more powerful the magic. But I need help
figuring out the costs and limits so it doesn't feel overpowered.
What kind of people would this magic system create?
```

### Integrated Development
```
I have a vague idea for a sci-fi setting: generation ships that have
been traveling so long that people forgot Earth. I want to create
the main character, but I need to develop enough of the world first.
Help me build both together.
```

### RPG Party Creation
```
Create a party of 4 characters for a fantasy campaign. They should be
from different cultures that are in conflict with each other. Show me
how their backgrounds create both team dynamics and tension.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these aspects when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `setting_type` | fantasy | Genre (fantasy, sci-fi, etc.) |
| `scope` | character with world context | What you're building |
| `purpose` | fiction writing | Novel, TTRPG, game, etc. |
| `existing_world` | new world | Building new or using established |

## Key Frameworks

### The Holy Triangle (Magic/Technology)
Every system needs balance between:
- **Power**: What it can do
- **Cost**: What it requires
- **Limitation**: What it can't do

### The Narrow and Deep Approach
Don't build everything. Focus on 2-3 world elements and develop them thoroughly. A detailed culture is worth more than 20 named kingdoms.

### Character-World Connection Points
Every character should connect to:
- Cultural origin (values, skills, prejudices)
- Historical context (events in their lifetime)
- Magic/tech relationship (access, abilities, social implications)
- Geographic influence (homeland shaped them)
- Political position (hierarchy, power dynamics)

## What Makes This Different

Unlike separate character or world-building tools:
- Characters emerge FROM world elements
- Worlds are revealed THROUGH characters
- Every detail connects to something else
- Backstories feel inevitable, not arbitrary

---
Downloaded from [Find Skill.ai](https://findskill.ai)
