---
name: childrens-book-illustrator
version: 1.0.0
description: AI children's book illustration prompt generator with character consistency techniques
author: FindSkill.ai
license: MIT
---

# Initialization

This skill provides comprehensive prompt templates and techniques for generating consistent children's book illustrations using AI image generators like Midjourney, DALL-E, Stable Diffusion, and others.

**Time to initialize**: ~1 minute (prompt-only skill)

## Overview

The Children's Book Illustrator skill helps self-publishing authors, parents, and educators create beautiful picture book illustrations. It covers:

- Character design and consistency techniques
- 8 popular art styles for different age groups
- Scene composition templates
- Midjourney --cref character reference workflow
- Age-appropriate style guidelines
- Complete book illustration workflow

## Directory Structure

```
childrens-book-illustrator/
├── SKILL.md         # Main skill instructions and prompt templates
└── INIT.md          # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - copy SKILL.md content directly to use with any AI assistant.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r childrens-book-illustrator/ ~/.claude/skills/childrens-book-illustrator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat
4. Describe your book project to get customized prompts

## Quick Start Example

After initializing, try this prompt with any AI:

```
I'm writing a children's book about a shy fox named Maple who learns to be brave.

Character: Maple is a young red fox with big amber eyes, cream-colored chest fur, and a fluffy tail with a white tip. She wears a tiny blue scarf.

I need illustrations for:
1. Character reference sheet showing different poses
2. Opening scene: Maple hiding behind a tree, looking nervous
3. Climax: Maple standing tall and confident in a meadow

Art style: Soft watercolor like classic Beatrix Potter

Can you generate Midjourney prompts for these?
```

## Compatibility

Tested with:
- Claude (Anthropic)
- ChatGPT (OpenAI)
- Gemini (Google)
- Copilot (Microsoft)

Works with AI image generators:
- Midjourney (best character consistency with --cref)
- DALL-E / ChatGPT
- Stable Diffusion
- Leonardo AI
- Ideogram
- Adobe Firefly

## Variables Reference

| Variable | Default | Description |
|----------|---------|-------------|
| `{{character_name}}` | `Luna` | Main character name |
| `{{character_description}}` | `young girl with curly red hair` | Physical appearance |
| `{{art_style}}` | `whimsical watercolor` | Illustration style |
| `{{scene_setting}}` | `enchanted forest` | Environment |
| `{{mood}}` | `magical and wonder-filled` | Emotional tone |
| `{{age_group}}` | `4-8 years` | Target reader age |

## Supported Use Cases

- Picture book illustration
- Personalized children's books
- Educational materials
- Bedtime story visuals
- Character design for stories
- Book cover art
- Chapter book spot illustrations
- Classroom story resources
- Self-publishing projects

## Art Styles Included

1. Classic Watercolor (Beatrix Potter style)
2. Whimsical Digital (modern picture books)
3. Pixar/Disney Inspired (animated look)
4. Scandinavian Minimal (clean, simple)
5. Vintage/Retro (mid-century)
6. Detailed Fantasy (rich, elaborate)
7. Collage/Mixed Media (Eric Carle style)
8. Anime Influenced (manga aesthetic)

## Character Consistency Techniques

The skill includes detailed instructions for:
- Midjourney --cref parameter usage
- Character reference sheet generation
- Maintaining consistency without AI features
- Documentation and prompt tracking
- Multi-scene character workflows

---
Downloaded from [Find Skill.ai](https://findskill.ai)
