---
name: childrens-book-illustrator
description: Generate consistent character designs and whimsical illustrations for children's books using AI image generators. Use this skill when creating picture books, personalized stories, or educational materials. This skill requires initialization before first use - run INIT.md instructions.
platforms:
  - claude
  - chatgpt
  - gemini
  - copilot
difficulty: intermediate
variables:
  - name: "character_name"
    default: "Luna"
    description: "Name of the main character"
  - name: "character_description"
    default: "young girl with curly red hair"
    description: "Physical appearance of the character"
  - name: "art_style"
    default: "whimsical watercolor"
    description: "Illustration style"
  - name: "scene_setting"
    default: "enchanted forest"
    description: "Environment for the scene"
  - name: "mood"
    default: "magical and wonder-filled"
    description: "Emotional tone"
  - name: "age_group"
    default: "4-8 years"
    description: "Target reader age range"
---

# Children's Book Illustrator

Create beautiful, consistent children's book illustrations using AI image generators. Generate character designs, storybook scenes, and whimsical art for picture books.

## Quick Start

```
I need illustrations for a children's book about: [story summary]
Main character: [name and appearance]
Art style: [watercolor/digital/Pixar/etc.]
Target age: [age range]
```

## Character Design Formula

### Essential Character Elements

Define these for every character:
- **Species:** human, animal, fantasy creature
- **Age appearance:** toddler, child, teen
- **Hair/fur:** color, style, length
- **Eyes:** color, size, shape
- **Skin/fur tone:** specific color
- **Distinguishing features:** freckles, glasses, etc.
- **Signature outfit:** colors, style, accessories
- **Default expression:** curious, shy, adventurous

### Character Reference Prompt

```
[name], [age] [species], [hair/fur description], [eye description], [skin tone], wearing [signature outfit], [distinguishing features], [expression], children's book illustration style, [art medium]
```

**Example:**
```
Oliver the bunny, young rabbit with soft gray fur, large round blue eyes, long floppy ears with pink insides, wearing a cozy red knit sweater and tiny brown boots, shy gentle expression, children's book illustration style, soft watercolor
```

## Art Style Quick Reference

### Classic Watercolor (Ages 3-8)
```
[scene], soft watercolor illustration, gentle washes of muted colors, delicate brushstrokes, Beatrix Potter style, traditional children's book art
```

### Whimsical Digital (Ages 4-10)
```
[scene], whimsical digital illustration, bright cheerful colors, playful cartoon style, modern children's book art
```

### Pixar/Disney Inspired (Ages 4-12)
```
[scene], Pixar style children's illustration, expressive eyes, dynamic pose, cinematic lighting, professional animation art
```

### Scandinavian Minimal (Ages 2-6)
```
[scene], Scandinavian minimal illustration, simple geometric shapes, soft muted pastels, clean Nordic picture book style
```

### Vintage/Retro (Ages 3-8)
```
[scene], vintage children's book illustration, mid-century modern style, retro limited palette, Mary Blair inspired
```

### Detailed Fantasy (Ages 6-12)
```
[scene], detailed fantasy children's illustration, rich elaborate environment, magical golden hour lighting, storybook fantasy art
```

### Collage/Mixed Media (Ages 2-6)
```
[scene], collage style children's illustration, mixed media textures, paper cut-out aesthetic, Eric Carle inspired
```

### Anime Influenced (Ages 6-12)
```
[scene], anime style children's book illustration, large expressive eyes, soft cel shading, cute manga aesthetic
```

## Scene Templates

### Indoor Scene
```
[character description] in [room], [activity], [furniture/props], [lighting: cozy lamplight/sunny window], [art style], [mood], children's book illustration
```

### Outdoor Nature Scene
```
[character description] in [nature setting], [activity], [time of day], [weather/season], [flora/fauna], [art style], [mood], children's book illustration
```

### Character Interaction
```
[character 1] and [character 2] [interaction] in [setting], [emotional dynamic], [art style], [mood], children's book illustration
```

### Emotional Moment
```
[character description], [emotion], [body language/expression], [supporting visual elements], [lighting to match emotion], [art style], children's book illustration
```

### Action Scene
```
[character description] [dynamic action], [dramatic setting], [sense of movement], [exciting elements], [art style], children's book illustration
```

## Maintaining Character Consistency

### Midjourney --cref Method
```
[scene with character], [art style] --cref [URL of reference image] --cw 100
```

### Without --cref
1. Create character reference sheet first:
```
Character reference sheet for [name], [full description], multiple poses and expressions, turnaround view, consistent design, [art style]
```

2. Use EXACT same character description in every prompt
3. Keep identical art style keywords throughout
4. Save and reference successful prompts

## Midjourney Parameters

| Parameter | Purpose | Recommended |
|-----------|---------|-------------|
| `--ar` | Aspect ratio | `3:2` (spread), `2:3` (portrait) |
| `--s` | Stylization | `100-250` (illustrated look) |
| `--cref` | Character ref | URL to reference |
| `--cw` | Character weight | `80-100` |
| `--no` | Exclude | `--no realistic photograph` |

## Age-Appropriate Guidelines

### Board Books (0-3)
- Simple bold shapes
- High contrast colors
- Single focal point
- Minimal background
- Non-threatening imagery

### Picture Books (3-8)
- More detail and complexity
- Rich color palettes
- Multiple scene elements
- Expressive characters
- Visual storytelling

### Early Reader (6-9)
- Spot illustrations
- Sophisticated compositions
- Action scenes
- Detailed environments
- Emotion focus

## Book Illustration Workflow

### Phase 1: Character Development
1. Define character completely
2. Generate character sheet
3. Create 3-5 poses
4. Select best references
5. Document exact prompts

### Phase 2: Scene Planning
1. List all scenes (12-16 typical)
2. Thumbnail compositions
3. Note text placement
4. Plan emotional arc

### Phase 3: Generation
1. Generate in story order
2. Use character refs consistently
3. Maintain style throughout
4. Generate multiple versions

### Phase 4: Refinement
1. Review consistency
2. Regenerate problems
3. Use inpainting for fixes
4. Final adjustments

## Common Mistakes to Avoid

**Character Issues:**
- Changing colors between scenes
- Inconsistent clothing details
- Varying art styles mid-book
- Different proportions

**Composition Issues:**
- Character too small
- Cluttered backgrounds
- No clear focal point
- Ignoring text space

## Example: Complete Character + Scene

**Character establishment:**
```
Oliver the bunny, young rabbit with soft gray fur, large round blue eyes, long floppy ears with pink insides, wearing a cozy red knit sweater and tiny brown boots, shy gentle expression, children's book illustration style, soft watercolor, warm inviting atmosphere
```

**Scene with character:**
```
Oliver the gray bunny in red sweater hopping through an autumn forest, golden leaves falling, late afternoon sunlight filtering through trees, mushrooms and ferns on forest floor, soft watercolor children's book illustration, magical adventurous mood
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
