---
name: consistent-character-designer
version: 1.0.0
description: Design consistent AI characters across multiple images and scenes with Midjourney, DALL-E, and Stable Diffusion
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive character consistency system for AI image generators. Covers character specification documents, reference sheet creation, tool-specific techniques (Midjourney --cref, DALL-E Gen ID, Stable Diffusion LoRA/IP-Adapter), scene generation workflows, and project-specific pipelines for children's books, comics, brand mascots, and games.

**Time to initialize**: ~5 minutes

## Directory Structure

```
consistent-character-designer/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: Midjourney (v6+), DALL-E (GPT-4o/5), Stable Diffusion (ComfyUI/A1111), and any AI assistant for prompt generation.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Define your character with the Character Bible template (Phase 1)
2. Create a hero reference image — this is your "ground truth"
3. Generate a multi-angle reference sheet (front, 3/4, profile, full body)
4. Use tool-specific techniques for your AI image generator:
   - **Midjourney**: --cref [URL] --cw 90 --sref [style URL]
   - **DALL-E**: Stay in same conversation, reference previous images
   - **Stable Diffusion**: Train LoRA or use IP-Adapter
5. Follow the production pipeline for batch scene generation
6. Troubleshoot any consistency issues using the fix guide

### Key Principles

- Higher specificity = more consistency (describe EVERY detail)
- Always create a reference sheet BEFORE generating scenes
- Use --cw 80-100 in Midjourney for maximum character matching
- For DALL-E, stay in the same conversation session
- For Stable Diffusion, LoRA training gives the best results
- Include character description in EVERY prompt, not just the first one
- Compare all images side by side during consistency checks

## Compatibility

Tested with: All AI assistants + Midjourney v6+, DALL-E (GPT-4o/5), Stable Diffusion (ComfyUI, A1111), Leonardo AI, and other AI image generators.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{character_description}}` | `a young woman with red curly hair, green eyes, freckles, wearing a vintage leather jacket` | Character's appearance |
| `{{art_style}}` | `semi-realistic digital illustration` | Visual art style |
| `{{project_type}}` | `children's book illustrations` | What the characters are for |
| `{{ai_tool}}` | `Midjourney` | AI image tool being used |
| `{{scene_count}}` | `8-10 scenes` | Number of scenes needed |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
