---
name: conversion-copywriting-pro
version: 1.0.0
---

# Conversion Copywriting Pro - Initialization

A research-driven copywriting skill that combines Voice of Customer (VOC) mining, psychological persuasion principles, and A/B testing methodology to create high-converting landing page copy.

## What This Skill Does

Unlike template-based copywriting approaches, this skill teaches you a complete conversion optimization system:

1. **VOC Research**: Mine customer reviews, Reddit, and support tickets for exact customer language
2. **Headline 25 Exercise**: Generate 25 headline variations using proven formulas
3. **Feature-to-Benefit Translation**: Transform technical features into emotional benefits
4. **Message Match**: Ensure ad-to-landing-page alignment
5. **Friction Elimination**: Remove barriers to conversion
6. **A/B Testing Framework**: Systematically test and optimize

## Package Structure

```
conversion-copywriting-pro/
├── SKILL.md    # Main skill prompt (copy this to your AI)
└── INIT.md     # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy to your Claude Code skills directory
cp -r conversion-copywriting-pro/ ~/.claude/skills/conversion-copywriting-pro/
```

Then reference it in your Claude Code settings or use it directly.

### ChatGPT / Gemini / Copilot / Other AI Assistants

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or as the first message in a new conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{product_name}}` | `[Your Product]` | The name of your product, service, or offer |
| `{{target_audience}}` | `Busy Professionals` | Who the landing page speaks to |
| `{{primary_pain_point}}` | `Wasting time on manual tasks` | The specific problem your audience wants solved |
| `{{desired_outcome}}` | `Save 10 hours per week` | The tangible benefit or transformation |
| `{{offer_type}}` | `Free Trial` | What the user gets for converting (trial, demo, download) |
| `{{framework}}` | `PAS` | The copywriting formula to use (PAS, AIDA, StoryBrand) |

## Example Usage

After loading the skill, try:

```
I'm launching a SaaS tool called "InvoiceFlow" for freelancers who struggle with late payments.
The main pain point is spending hours chasing clients for payment.
The desired outcome is getting paid 3x faster with automated reminders.
Help me create conversion-optimized landing page copy using the research-first approach.
```

The AI will:
1. Ask clarifying questions about your product
2. Recommend the best copywriting framework
3. Generate 5 headline variations
4. Write complete landing page copy (Hero, Problem, Solution, Benefits, How It Works, FAQ, Final CTA)
5. Suggest A/B testing ideas

## Key Concepts Covered

- **Above the Fold** - Critical first-impression real estate
- **Value Proposition (UVP)** - Clear benefit statement formula
- **Hero Section** - Structure and components
- **CTA Optimization** - Strong vs. weak call-to-action patterns
- **Social Proof** - Placement and hierarchy
- **Friction Elimination** - Removing conversion barriers
- **Message Match** - Ad-to-landing-page alignment
- **PAS Framework** - Pain-Agitate-Solution formula
- **Feature vs. Benefit** - The "So What?" translation technique
- **Scarcity/Urgency** - Ethical psychological triggers
- **Micro-copy** - Small text that reduces anxiety
- **Visual Hierarchy** - Guiding the eye to key elements

## Workflows Included

### 1. Voice of Customer Mining
Extract exact customer language from reviews, Reddit, and support tickets before writing any copy.

### 2. Headline 25 Exercise
Generate 25 headline variations in 15 minutes using benefit, problem, curiosity, how-to, and question formulas.

### 3. Feature-to-Benefit Translation
Apply the "So What?" technique to transform technical features into emotional benefits.

## Troubleshooting Guides

The skill includes diagnosis and solutions for:
- High traffic, low conversions
- High bounce rate
- Form abandonment
- Visitors scroll but don't convert
- Low-quality leads

## Advanced Techniques

- **Breadcrumb Technique** - Micro-commitments instead of long forms
- **Loss Aversion Framing** - "Stop losing" vs. "Start saving"
- **Zeigarnik Effect** - Progress bars on multi-step forms
- **Anchoring** - High reference point before showing price
- **Social Proof Hierarchy** - Most to least persuasive proof types

## Related Skills

Pair this skill with:
- **Landing Page Copywriter** - Foundational templates
- **A/B Testing** - Statistical testing methodology
- **Funnel Analysis** - Conversion funnel optimization
- **Ad Copy Generator** - Matching ad copy for message match

## Research Sources

This skill synthesizes best practices from:
- Unbounce Conversion Intelligence
- CXL (Conversion XL)
- Copyhackers (Joanna Wiebe)
- KlientBoost
- HubSpot
- Marketing Examples (Harry Dry)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
