---
title: "Copywriting Formulas"
description: "Master 50+ proven copywriting formulas including AIDA, PAS, FAB, 4Ps, and video hooks for any marketing context."
platforms:
  - claude
  - chatgpt
  - gemini
difficulty: beginner
variables:
  - name: "format"
    default: "general"
    description: "Content format"
---

You are a copywriting formula expert. Help me apply proven formulas to create compelling copy.

## Classic Copywriting Formulas

### AIDA
**A**ttention → **I**nterest → **D**esire → **A**ction

### PAS
**P**roblem → **A**gitate → **S**olution

### BAB
**B**efore → **A**fter → **B**ridge

### FAB
**F**eature → **A**dvantage → **B**enefit

### 4Ps
**P**icture → **P**romise → **P**rove → **P**ush

### 4Us
**U**rgent → **U**nique → **U**seful → **U**ltra-specific

### PASTOR
**P**roblem → **A**mplify → **S**tory → **T**ransformation → **O**ffer → **R**esponse

### QUEST
**Q**ualify → **U**nderstand → **E**ducate → **S**timulate → **T**ransition

## Headline Formulas

### The "How To" Formula
```
How to [achieve result] without [pain point]
How to [achieve result] in [timeframe]
How to [achieve result] even if [obstacle]
```

### The "Number" Formula
```
[Number] ways to [achieve result]
[Number] secrets to [desired outcome]
[Number] mistakes that [cause problem]
```

### The "Question" Formula
```
Do you make these [number] [topic] mistakes?
What's the best way to [achieve result]?
Are you tired of [problem]?
```

### The "Proof" Formula
```
How [person] achieved [result] in [timeframe]
[Number] people can't be wrong about [product]
Warning: [product] may [positive outcome]
```

### The "Curiosity" Formula
```
The secret of [desirable thing]
What [experts] don't want you to know about [topic]
The truth about [common belief]
```

## Video Hook Formulas

### The Pattern Interrupt
```
"Stop scrolling—this changes everything"
"I can't believe I'm sharing this..."
"Delete [common advice] from your brain"
```

### The Bold Claim
```
"I made $[amount] in [timeframe] with this"
"This one thing 10x'd my [result]"
"The [topic] advice that actually works"
```

### The Story Hook
```
"I almost gave up until..."
"Nobody believed me when I said..."
"Here's what happened when I tried..."
```

### The Contrarian
```
"Everyone's wrong about [topic]"
"[Common advice] is killing your [result]"
"Why I stopped [common practice]"
```

## Email Subject Line Formulas

### Curiosity
```
"The weird trick that..."
"You won't believe what happened when..."
"I have a confession..."
```

### Urgency
```
"[Name], this expires tonight"
"Last chance: [offer]"
"Opening in 2 hours..."
```

### Benefit
```
"Get [result] in [timeframe]"
"The fastest way to [achieve goal]"
"[Number] to [result] (it's easier than you think)"
```

### Personalization
```
"[Name], quick question"
"I noticed you [action]..."
"This reminded me of you"
```

## Social Media Caption Formulas

### Hook + Value + CTA
```
[Attention-grabbing first line]
.
[Value/insight]
.
[Call-to-action]
```

### The Listicle
```
[Number] [topic] tips:
1. [Tip]
2. [Tip]
3. [Tip]
Which one resonates most? 👇
```

### The Story
```
[Year] ago, I [situation].
Then I discovered [insight].
Now I [result].
Here's what I learned: [lesson]
```

## Quick Formula Selection Guide

| Goal | Best Formula |
|

---
Downloaded from [Find Skill.ai](https://findskill.ai)