---
name: copywriting-marketing-generator
version: 1.0.0
description: All-in-one marketing content creation for small businesses - ad copy, social posts, product descriptions, taglines, and emails
author: FindSkill.ai
license: MIT
---

# Initialization

Copywriting & Marketing Content Generator is your all-in-one marketing assistant for creating conversion-focused content across multiple platforms. Designed for small business owners who need quick, effective marketing without agency costs.

## Overview

This is a prompt-only skill with no scripts to generate. The skill handles:

- Social media posts (Facebook, Instagram, LinkedIn, Twitter, TikTok)
- Advertising copy (Google Ads, Facebook/Instagram Ads)
- Email marketing (subject lines, preview text, body copy)
- Product descriptions (e-commerce, services)
- Taglines and headlines

**Time to initialize**: ~1 minute (copy and paste)

## Directory Structure

```
copywriting-marketing-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - simply copy the SKILL.md content to use.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r copywriting-marketing-generator/ ~/.claude/skills/copywriting-marketing-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Quick Start Examples

### Multi-Platform Campaign
```
I run a small bakery and need content for a Valentine's Day promotion.
I need:
1) A Facebook ad for custom heart-shaped cakes
2) An Instagram caption for a photo of our Valentine's cupcakes
3) An email subject line and preview text for our newsletter
Orders must be placed by Feb 10th. Our tone is warm and a little playful.
```

### Google Ads
```
Write Google Search ads for my plumbing business. We specialize in
emergency repairs in the Denver area. Available 24/7, usually arrive
within an hour. We want to emphasize reliability and speed.
```

### Product Descriptions
```
Create product descriptions for three handmade soy candles:
1) Lavender Dreams - calming lavender scent, 8oz
2) Mountain Morning - pine and fresh air, 12oz
3) Cozy Evening - cinnamon and vanilla, 8oz
Each is $18. Include short description, full description, and bullets.
```

### Quick Social Posts
```
Quick social posts about our new coffee menu items. We're a local
coffee shop in Portland with a hipster vibe. Just added oat milk
cold brew and a maple pecan latte for fall. Need posts for IG, FB,
and Twitter.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these aspects when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `business_type` | small business | Type of business |
| `content_type` | (none) | What you need |
| `platform` | (none) | Where it'll be posted |
| `tone` | professional but approachable | Brand voice |

## Platform Character Limits

| Platform | Limit | Optimal |
|----------|-------|---------|
| Twitter/X | 280 | 71-100 |
| Instagram Caption | 2,200 | 138-150 |
| Facebook Post | 63,206 | 40-80 |
| LinkedIn Post | 3,000 | 1,300 |
| Google Headline | 30 | 30 (use full) |
| Google Description | 90 | 90 (use full) |
| Email Subject | No limit | 30-50 |

## Built-In Frameworks

| Framework | Use For | Structure |
|-----------|---------|-----------|
| AIDA | Direct response | Attention → Interest → Desire → Action |
| PAS | Pain-point content | Problem → Agitate → Solution |
| FAB | Features | Feature → Advantage → Benefit |
| BAB | Transformation | Before → After → Bridge |

## What Makes This Different

Unlike specialized copywriting skills:
- Handles ALL marketing content types in one place
- Multi-piece requests (campaign sets)
- Character counts always included
- A/B variations built in
- Brand voice consistency across formats
- Small business focused (not enterprise)

---
Downloaded from [Find Skill.ai](https://findskill.ai)
