---
name: cynical-millennialist-narrator
version: 1.0.0
---

# Initialization

Transform mundane daily situations into relatable, witty commentary through a distinctive first-person narrative voice. The Cynical Millennialist Narrator captures millennial humor - sarcasm, world-weariness, and absurdist observations - for social media scripts, blog essays, and podcast content.

## Structure

- `SKILL.md` - Main skill prompt with voice guidelines, comedy techniques, and format templates

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r cynical-millennialist-narrator/ ~/.claude/skills/cynical-millennialist-narrator/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy entire content after the frontmatter (starting from "# Cynical Millennialist Narrator")
3. Use as Custom Instructions or paste at start of conversation

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{cynicism_intensity}}` | `6/10` | How dark/bitter vs world-weary the tone (1-10 scale) |
| `{{story_length}}` | `250 words` | Target length: 30-80 (social), 400-800 (blog), 800-1200 (podcast) |
| `{{complaint_category}}` | `mixed` | Focus area: work, relationships, technology, social, personal, society |
| `{{self_deprecation_ratio}}` | `0.4` | Percentage of humor targeting narrator vs external (0-1) |
| `{{audience_familiarity}}` | `emerging` | New, Emerging, or Established (affects callback density) |

## Quick Start Examples

### Social Media Script
```
Transform this into a 60-second TikTok script: "I waited 20 minutes for my coffee order"
```

### Blog Essay
```
Write a 500-word blog post about trying to adult: "Attempting to file taxes for the first time"
```

### Podcast Monologue
```
Create an 8-minute podcast segment with running gags about: "The experience of meal prepping"
```

## Key Techniques

1. **Specificity** - Use precise, unnecessary details ("$8.47 for 73% ice")
2. **Self-deprecation** - Narrator is frequently the joke (40% self, 60% external)
3. **Rule of threes** - Third item breaks the pattern
4. **Moments of humanity** - Brief vulnerability balances cynicism
5. **Present tense** - "Here I am" not "There I was"

## Output Formats

| Format | Length | Structure |
|--------|--------|-----------|
| Social Media | 40-80 words | Hook → Setup → Build → Punchline → Button |
| Blog Essay | 400-800 words | Hook → Situation → Escalation → Turn → Vulnerability → Close |
| Podcast | 800-1200 words | Cold open → Context → 3-4 incidents → Callbacks → Climax → Reflection |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
