---
name: ethical-clickbait-balancer
version: 1.0.0
---

# Initialization

**Ethical Clickbait Balancer** helps content creators, journalists, and marketers craft attention-grabbing headlines that balance engagement with honesty. Score deception risk, create ethical curiosity gaps, and optimize titles without misleading your audience.

## Structure

```
ethical-clickbait-balancer/
├── SKILL.md      # Main skill prompt (comprehensive headline ethics framework)
└── INIT.md       # This initialization file
```

## Files to Generate

None required. This is a prompt-only skill.

## Post-Init Steps

### Claude Code

```bash
# Copy skill to your Claude Code skills directory
cp -r ethical-clickbait-balancer/ ~/.claude/skills/ethical-clickbait-balancer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or as the first message in a conversation

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `sensationalism_tolerance` | `medium` | How much dramatic language is acceptable (minimal/low/medium/high/extreme) |
| `platform_type` | `general_blog` | Target platform (social_media/news/youtube/linkedin/twitter/substack/academic/ecommerce) |
| `target_audience_sophistication` | `general` | Audience media literacy level (novice/general/professional/expert/academic) |
| `engagement_priority` | `balanced` | Balance engagement vs. credibility (credibility_first/balanced/engagement_first) |
| `content_length` | `medium` | How substantial the content is (micro/short/medium/long/video/research_paper) |
| `claim_verification_strictness` | `moderate` | How strictly to verify headline claims (lenient/moderate/strict/academic) |

## Quick Start

After installation, try these prompts:

**Evaluate an existing title:**
```
Evaluate this YouTube title for ethical integrity: "The Tech Industry's BIGGEST Secret Will Shock You (2025)". The content is a 12-minute data analysis of hiring trends that are counterintuitive but not shocking.
```

**Create curiosity gap titles:**
```
I'm writing about how most freelancers undercharge by 40%. Create 5 title options that create genuine curiosity without misleading readers.
```

**Multi-platform adaptation:**
```
Adapt this blog title for LinkedIn, Twitter, and YouTube while maintaining semantic accuracy: "Why Your Job Search Strategy Is Backwards (And What Actually Works)"
```

## Core Workflows

1. **Title Evaluation & Risk Assessment** - Score existing titles for deception risk, sensationalism, and engagement potential
2. **Curiosity Gap Creation** - Craft titles that intrigue without lying (honest open loops)
3. **Ethical Emotional Resonance** - Add emotional appeal without manipulation
4. **Multi-Platform Optimization** - Adapt titles for different platforms while maintaining accuracy
5. **Headline Claims Fact-Check** - Verify all claims in a headline are supported by content

## Key Concepts

- **Curiosity Gap**: Creating interest without deception
- **Semantic Accuracy**: Headlines that match content
- **Engagement Integrity**: Long-term trust over short-term clicks
- **Bait-and-Switch Avoidance**: Never promise what content doesn't deliver

---
Downloaded from [Find Skill.ai](https://findskill.ai)
