---
name: event-marketing-strategist
version: 1.0.0
---

# Initialization

Event Marketing Strategist helps you create comprehensive marketing strategies for virtual, hybrid, and in-person events. It covers the full lifecycle from pre-event promotion through post-event content repurposing, with specific tactics for omnichannel campaigns, attendee engagement, and ROI measurement.

## Structure

- `SKILL.md` - Main skill prompt with 10 comprehensive sections covering discovery, terminology, lifecycle management, channel strategies, measurement, and crisis management

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r event-marketing-strategist/ ~/.claude/skills/event-marketing-strategist/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions
4. Begin with your event details to receive a customized marketing strategy

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{event_type}}` | `Virtual Webinar` | Event format (In-Person Conference, Hybrid Summit, Virtual Webinar, Executive Dinner) |
| `{{target_audience}}` | `B2B Professionals` | Primary demographic (Developers, C-Suite, Marketers, Gen Z Consumers) |
| `{{marketing_timeline}}` | `12 weeks` | Duration of the promotional campaign leading up to the event |
| `{{primary_goal}}` | `Lead Generation` | Main objective (Brand Awareness, Product Launch, Community Engagement, Lead Gen) |
| `{{budget_tier}}` | `Mid-Range` | Financial constraint (Low/Bootstrapped, Mid-Range, High/Enterprise) |
| `{{expected_attendees}}` | `500` | Target number of attendees (in-person + virtual combined) |

## Example Usage

```
Create a 12-week marketing timeline for a Hybrid B2B SaaS Conference
targeting 500 in-person and 2,000 virtual attendees. The primary goal
is Lead Generation. Include email themes, social media angles, and
paid ad focus for each phase.
```

## What This Skill Provides

1. **Discovery Protocol** - Questions to gather context before strategizing
2. **Terminology Glossary** - Event marketing vocabulary (Hybrid, Simulive, NPS, etc.)
3. **Lifecycle Framework** - Pre-event, During-event, Post-event strategies
4. **Channel Strategies** - Email, Social, Paid Ads with specific tactics
5. **KPI Benchmarks** - Industry-standard metrics for success
6. **Hybrid Event Guidance** - Bridging virtual and in-person experiences
7. **Budget Templates** - Bootstrapped, Mid-Range, Enterprise allocations
8. **Crisis Protocols** - Low registration, speaker cancellations, pivots
9. **Best Practices** - What to do and what to avoid
10. **Deliverable Templates** - Marketing timelines, sponsorship decks, reports

## Best For

- Event marketers planning conferences, webinars, or summits
- B2B/B2C marketers using events for lead generation
- Community managers organizing engagement events
- Marketing teams needing omnichannel event promotion
- Anyone measuring event ROI and proving value

---
Downloaded from [Find Skill.ai](https://findskill.ai)
