---
name: future-prediction-comedic
version: 1.0.0
---

# Initialization

Generate hilariously absurd but logically coherent future timelines based on your current life situation. Uses professional comedy techniques including escalation, rule of 3, expectation subversion, and callback integration.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive comedy writing instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r future-prediction-comedic/ ~/.claude/skills/future-prediction-comedic/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (starting from "You are an expert comedic futurist...")
3. Paste into your AI assistant's system prompt or as initial context

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{timeline_length}}` | `25 years` | How far into the future to predict (10, 20, 30 years) |
| `{{absurdity_level}}` | `medium` | Tone intensity: low (mildly funny), medium (very funny), high (completely unhinged) |
| `{{callback_frequency}}` | `moderate` | How often to reference original details: sparse, moderate, heavy |
| `{{branching_type}}` | `single_timeline` | Output format: single_timeline, dual_timeline, triple_timeline |
| `{{escalation_rate}}` | `gradual` | Speed of absurdity increase: gradual, moderate, rapid, chaotic |
| `{{tone_style}}` | `deadpan` | Narrative voice: deadpan, sarcastic, melodramatic, satirical |

## Usage Example

```
I'm a 28-year-old accountant in Chicago who just adopted a cat named Spreadsheet,
broke up with my college sweetheart, and secretly dreams of being a stand-up comedian.
I'm terrified of public speaking but also hate my job. Generate a 20-year comedic timeline
with high absurdity showing how my life might unfold.
```

## Key Features

- **Situation Extraction**: Parses job, relationships, hobbies, fears, and specific details into comedy anchors
- **Escalation Generation**: Creates progressively more absurd but logically-connected future events
- **Rule of 3 Application**: Uses setup → repetition → subversion pattern for punchlines
- **Multi-Path Branching**: Generates alternate timelines showing divergent outcomes
- **Callback Integration**: References original user details throughout for coherence
- **Deadpan Narration**: Delivers ridiculous content with serious, neutral tone

## Comedy Techniques Used

1. **Escalation**: Each event increases in absurdity while maintaining logical connection
2. **Rule of 3**: Establish pattern, reinforce, then subvert expectations
3. **Callbacks**: Reference original details for recognition humor and coherence
4. **Expectation Subversion**: Deliver unexpected outcomes at climax points
5. **Deadpan Delivery**: Serious tone + absurd content = humor through incongruity
6. **Logical Absurdity**: Absurd outcomes that follow strict internal logic

---
Downloaded from [Find Skill.ai](https://findskill.ai)
