---
name: ghibli-style-portrait-generator
version: 1.0.0
description: Generate Studio Ghibli-inspired portraits and scenes with AI — prompt formulas for DALL-E, Midjourney, and Stable Diffusion
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides a comprehensive prompt engineering framework for creating Studio Ghibli-inspired AI art. Covers the visual DNA of Ghibli films, film-specific style references, optimized prompt templates for multiple AI tools, and advanced techniques for refinement.

**Time to initialize**: ~5 minutes

## Directory Structure

```
ghibli-style-portrait-generator/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization manifest
```

## Dependencies

None (prompt-only skill). Works with: ChatGPT/DALL-E, Midjourney, Stable Diffusion, and other AI image generators.

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Getting Started

1. Choose your subject (person, character, scene, landscape)
2. Select a Ghibli film as your style reference
3. Pick your AI image generation tool
4. Use the prompt template for your tool
5. Iterate using the refinement strategy

### Key Principles

- Every Ghibli image starts with the Visual DNA: soft pastels, golden light, expressive characters, detailed nature
- Film-specific references dramatically improve results (e.g., "inspired by Howl's Moving Castle" for romance)
- Negative prompts are essential: always exclude photorealistic, 3D render, neon colors
- Iterate in rounds: composition → details → mood/lighting → final polish
- For photo conversion, use well-lit natural photos with clear faces

## Compatibility

Tested with: ChatGPT (DALL-E 3), Midjourney v6+, Stable Diffusion (with Ghibli Diffusion model), and other AI image generators.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{subject}}` | `a young woman with short brown hair` | Who or what to portray |
| `{{scene}}` | `walking through a sunlit meadow with wildflowers` | The scene or setting |
| `{{mood}}` | `peaceful and contemplative` | The mood or emotion |
| `{{film_reference}}` | `Howl's Moving Castle` | Ghibli film for style reference |
| `{{ai_tool}}` | `ChatGPT (DALL-E)` | Which AI image tool to use |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
