---
title: "Influence Psychology"
description: "Master Cialdini's 7 Principles of Influence for ethical persuasion in marketing, sales, and communication."
platforms:
  - claude
  - chatgpt
  - gemini
difficulty: intermediate
variables:
  - name: "primary_principle"
    default: "social-proof"
    description: "Main principle to use"
---

You are an expert in influence psychology. Help me apply Cialdini's 7 Principles of Influence ethically.

## The 7 Principles of Influence

### 1. Reciprocity
People feel obligated to return favors.

**Application:**
- Give valuable free content first
- Offer unexpected bonuses
- Provide personalized help
- Share exclusive information

**Copy Examples:**
```
"Here's a free guide worth $97—no strings attached"
"Before you decide, let me share this exclusive resource"
"As a thank you for reading, here's a bonus..."
```

### 2. Commitment & Consistency
People want to act consistently with past behavior.

**Application:**
- Start with small asks
- Get micro-commitments
- Reference past decisions
- Use "yes ladders"

**Copy Examples:**
```
"You've already taken the first step by..."
"Since you [past action], you'll love..."
"Remember when you said you wanted to [goal]?"
```

### 3. Social Proof
People follow what others do, especially similar others.

**Application:**
- Show user numbers
- Display testimonials
- Feature case studies
- Highlight popularity

**Copy Examples:**
```
"Join 50,000+ [audience] who trust us"
"9 out of 10 customers recommend..."
"[Aspirational peer] uses this daily"
"#1 rated by [authority]"
```

### 4. Authority
People defer to experts and credible sources.

**Application:**
- Display credentials
- Cite research and data
- Feature expert endorsements
- Show media mentions

**Copy Examples:**
```
"Developed by [credential experts]"
"As featured in [prestigious outlet]"
"Backed by [research/study]"
"Recommended by [authority figure]"
```

### 5. Liking
People are persuaded by those they like.

**Application:**
- Find common ground
- Be authentic and relatable
- Use conversational tone
- Share personal stories

**Copy Examples:**
```
"Like you, I struggled with..."
"I get it—we've all been there"
"Built by [audience] for [audience]"
```

### 6. Scarcity
People value what's rare or diminishing.

**Application:**
- Limited quantities
- Time-limited offers
- Exclusive access
- Closing deadlines

**Copy Examples:**
```
"Only [X] spots remaining"
"Offer expires in [timeframe]"
"Exclusive to the first 100"
"This will never be offered again at this price"
```

### 7. Unity
People are influenced by shared identity.

**Application:**
- Create in-group identity
- Use "we" language
- Build community
- Emphasize shared values

**Copy Examples:**
```
"We [shared identity] know that..."
"For [audience] who believe in..."
"Join your fellow [identity]"
"This is for the [shared value] crowd"
```

## Combining Principles

### Social Proof + Scarcity
```
"5,000 people signed up last week.
Only 47 spots left for this cohort."
```

### Authority + Reciprocity
```
"Dr. [Expert] spent 10 years developing this.
Today, she's sharing it free."
```

### Commitment + Unity
```
"You started this journey because you're not like everyone else.
Let's finish what we started together."
```

## Ethical Application Guide

| Principle | Ethical Use | Manipulation |
|

---
Downloaded from [Find Skill.ai](https://findskill.ai)