---
name: logo-brand-identity-creator
version: 1.0.0
description: Generate professional logo concepts, brand color palettes, and complete visual identity systems
author: FindSkill.ai
license: MIT
---

# Initialization

## Overview

This skill provides comprehensive guidance for creating brand identities including logo concepts, color palettes, typography systems, and visual identity guidelines. It covers logo design principles, color psychology, typography selection, and industry-specific conventions.

**Time to initialize**: ~1 minute

## Directory Structure

```
logo-brand-identity-creator/
├── SKILL.md          # Main skill instructions
└── INIT.md           # This initialization file
```

## Dependencies

None - this is a prompt-only skill with no external dependencies.

## Files to Generate

None - this skill consists only of the SKILL.md prompt file.

## Post-Init Steps

### For Claude Code Users

```bash
# Copy to your skills directory
cp -r logo-brand-identity-creator/ ~/.claude/skills/logo-brand-identity-creator/
```

### For Other AI Assistants

1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with:
- Claude (claude.ai, Claude Code)
- ChatGPT (GPT-4, GPT-4o)
- Gemini (Pro, Ultra)
- GitHub Copilot

## Variables

Customize these placeholders in the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{business_name}}` | (empty) | Name of the business or brand |
| `{{industry}}` | (empty) | Business industry or sector |
| `{{target_audience}}` | (empty) | Primary target demographic |
| `{{brand_personality}}` | `professional, modern, trustworthy` | Desired brand personality traits |
| `{{style_preference}}` | `minimalist` | Logo style preference |

## Skill Capabilities

This skill enables you to:

1. **Create Logo Concepts**
   - Wordmarks (typography-based logos)
   - Lettermarks (monogram logos)
   - Symbols (abstract/pictorial icons)
   - Combination marks (symbol + wordmark)
   - Emblems (badge-style logos)

2. **Develop Color Palettes**
   - Primary, secondary, and accent colors
   - Color psychology aligned to industry
   - HEX, RGB, and CMYK specifications
   - Harmony types (monochromatic, complementary, analogous)

3. **Select Typography**
   - Primary and body typefaces
   - Font pairing recommendations
   - Typography hierarchy systems

4. **Apply Brand Strategy**
   - Brand positioning guidance
   - Personality trait identification
   - Competitor differentiation

5. **Generate AI Prompts**
   - Midjourney logo prompts
   - DALL-E logo prompts
   - Ideation and moodboard concepts

## Example Output

```
## Brand Identity: NovaPay

### Brand Strategy Summary
- **Positioning:** Modern fintech for digital natives
- **Personality:** Trustworthy, innovative, approachable
- **Value Proposition:** Banking without the bank feeling

---

### Concept A: "Modern Trust"

**Logo Type:** Combination Mark
**Design Direction:** Clean geometric symbol with modern wordmark

**Logo Description:**
An abstract "N" formed by two overlapping geometric shapes suggesting
connection and security. The negative space creates a subtle arrow
pointing upward, symbolizing growth. Paired with "NovaPay" in Inter
Bold, a modern sans-serif that communicates reliability.

**Why It Works:**
- Geometric shapes suggest precision and reliability (fintech)
- Upward arrow implies growth and progress
- Modern typography appeals to millennial/Gen Z audience
- Simple enough to work as app icon

**Color Palette:**
| Role | Color | HEX | Psychology |
|------|-------|-----|------------|
| Primary | Electric Blue | #2563EB | Trust, innovation |
| Secondary | Midnight | #1E293B | Sophistication |
| Accent | Mint Green | #34D399 | Growth, success |
| Neutral | Slate | #64748B | Professional |

**Typography:**
- **Primary:** Inter Bold - Headlines, logo
- **Body:** Inter Regular - Paragraphs, UI text

---

### Recommendation

Based on NovaPay's positioning as a modern fintech targeting younger
demographics, I recommend **Concept A** because:
- Blue builds trust while feeling more vibrant than traditional banks
- Geometric design appeals to tech-savvy audience
- Simple mark works across digital touchpoints (app, web, social)

### Next Steps
1. Refine in Figma or Adobe Illustrator
2. Test at various sizes (favicon, billboard)
3. Create dark mode and reversed variations
4. Develop brand guidelines document
```

## Color Psychology Quick Reference

| Color | Meaning | Best Industries |
|-------|---------|-----------------|
| Blue | Trust, stability | Finance, tech, healthcare |
| Green | Growth, health | Wellness, eco, finance |
| Red | Energy, passion | Food, entertainment, retail |
| Purple | Luxury, creativity | Beauty, luxury, creative |
| Orange | Creativity, enthusiasm | Youth brands, food, sports |
| Black | Sophistication | Luxury, fashion, tech |

## Research Sources

This skill was built using research from:

- [Superside: AI Logo Design Prompts](https://www.superside.com/blog/ai-prompts-logo-design)
- [Cieden: Logo Design Principles](https://cieden.com/book/atoms/logo/principles-of-logo-design)
- [Ignyte Brands: Color Psychology](https://www.ignytebrands.com/the-psychology-of-color-in-branding/)
- [Figma: Types of Logos](https://www.figma.com/resource-library/types-of-logos/)
- [Little Online: Typography in Branding](https://www.littleonline.com/insights/the-role-of-typography-in-branding/)

---
Downloaded from [FindSkill.ai](https://findskill.ai)
