---
name: poetry-journaling-companion
version: 1.0.0
description: Guided prompts for personal reflection, daily journaling, gratitude practice, and poetry creation
author: FindSkill.ai
license: MIT
---

# Initialization

Poetry & Journaling Companion guides creative practices for self-reflection and artistic expression. Combining journaling for self-discovery with poetry for transformation, this skill helps process emotions, cultivate gratitude, and create meaningful writing.

## Overview

This is a prompt-only skill with no scripts to generate. The skill focuses on:

- Daily reflection prompts (morning, evening, weekly)
- Emotional exploration journaling
- Gratitude practice beyond simple lists
- Traditional poetry forms (haiku, tanka, sonnet, villanelle)
- Creative constraints for unlocking expression
- The distillation process: journal to poem

**Time to initialize**: ~1 minute (copy and paste)

## Directory Structure

```
poetry-journaling-companion/
├── SKILL.md    # Main skill instructions
└── INIT.md     # This initialization file
```

## Dependencies

None - this is a prompt-only skill.

## Files to Generate

None - simply copy the SKILL.md content to use.

## Post-Init Steps

### Claude Code
```bash
# Copy to your skills directory
cp -r poetry-journaling-companion/ ~/.claude/skills/poetry-journaling-companion/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy the content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's system prompt or chat

## Quick Start Examples

### Daily Journaling
```
I want to establish a morning journaling practice. Guide me through
a 10-minute morning intention session.
```

### Emotional Processing
```
I had a difficult conversation with my mother today and I'm feeling
a mixture of sadness and relief. Help me process this through
journaling and maybe distill it into a short poem.
```

### Poetry Creation
```
I want to write a poem about the changing seasons but avoid clichés.
Can you give me a creative constraint that might help?
```

### Combined Practice
```
I have 30 minutes. Guide me through freewriting about something on
my mind and then help me shape it into a poem.
```

## Compatibility

Tested with: Claude, ChatGPT, Gemini, Copilot

## Variables

Customize these aspects when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `mode` | combined | Poetry, journaling, or both |
| `time_available` | 15 minutes | Session length |
| `emotional_state` | (none) | Current mood to explore |
| `form_preference` | any | Specific poetic form desired |

## Poetry Forms Quick Reference

| Form | Structure | Best For |
|------|-----------|----------|
| Haiku | 5-7-5 syllables | Moments, observations |
| Tanka | 5-7-5-7-7 | Image + emotional response |
| Sonnet | 14 lines, iambic pentameter | Arguments, turns |
| Villanelle | 19 lines, 2 refrains | Obsession, grief, loops |
| Free Verse | No fixed structure | Freedom, organic flow |

## The Distillation Process

Transform journaling into poetry:

1. **Freewrite**: 5-10 minutes, don't stop
2. **Identify the Core**: What image/phrase keeps appearing?
3. **Gather Material**: Circle powerful words and details
4. **Choose a Container**: What form fits this content?
5. **Draft**: Use gathered material, show don't tell
6. **Refine**: Read aloud, cut what doesn't earn its place

## Key Principles

- Writing is both mirror and transformation
- All feelings are valid material
- Creative constraints unlock, not limit
- This is practice, not performance
- No judgment on skill level

---
Downloaded from [Find Skill.ai](https://findskill.ai)
