---
name: product-review-troll
version: 1.0.0
---

# Initialization

Product Review Troll is a comedic content generation skill that creates hilariously exaggerated product reviews for entertainment and social sharing. It transforms mundane products into subjects of extreme critical analysis or lavish praise through satire, hyperbole, and committed persona work.

## Structure

```
product-review-troll/
├── SKILL.md     # Main skill prompt (copy to AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
# Copy skill to Claude Code skills directory
cp -r product-review-troll/ ~/.claude/skills/product-review-troll/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the YAML frontmatter (everything below the second `---`)
3. Paste into Claude, ChatGPT, Gemini, or your preferred AI assistant
4. Start generating absurd product reviews!

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `product_name` | `unnamed item` | The specific product to review |
| `review_tone` | `betrayed` | Emotional tone: betrayed, miraculously-impressed, conspiracy-minded, pretentious, sleep-deprived, philosophical |
| `review_extremity` | `medium` | Intensity: mild, medium, extreme |
| `star_rating` | `1` | Rating out of 5 (1 or 5 work best for humor) |
| `review_length` | `medium` | Length: tweet, short, medium, long |
| `comparison_domain` | `none` | Metaphor category: philosophy, relationships, history, quantum-physics, cooking, sports, finance, none |
| `target_platform` | `reddit` | Format: reddit, twitter, instagram, tiktok, amazon |

## Quick Start Examples

### Betrayed Customer Review
```
Generate an absurdly negative 1-star review of a standard toaster from the
perspective of someone emotionally devastated by uneven browning. Escalate
to existential territory. Format for Reddit.
```

### Miracle Product Review
```
Write an unreasonably positive 5-star review of a basic coffee mug that
treats it as a life-changing spiritual experience. Use poetic metaphors
and attribute impossible benefits.
```

### Conspiracy Theory Review
```
Create a paranoid 2-star review of AA batteries that connects them to
corporate planned obsolescence. Build an internally consistent but
increasingly absurd theory.
```

### Twitter Thread
```
Generate a 6-tweet thread reviewing a desk lamp as if it were a toxic
ex-partner. Use escalating relationship metaphors. Make it screenshot-worthy.
```

## Comedic Techniques Used

- **Hyperbole**: Extreme exaggeration for effect
- **Satire**: Mocking consumer culture and review conventions
- **Deadpan**: Treating absurdity with complete seriousness
- **Rule of Threes**: Pattern-pattern-subversion structure
- **Escalation**: Gradually increasing absurdity
- **Premise Commitment**: Never breaking character
- **Incongruity**: Unexpected juxtapositions

## Target Platforms

| Platform | Best Format | Optimal Length |
|----------|-------------|----------------|
| Reddit | Story-driven narrative | 250-400 words |
| Twitter/X | Thread (4-6 tweets) | 50-100 words per tweet |
| Amazon | Traditional review format | 150-300 words |
| Instagram | Caption with visual hook | 150-250 words |
| TikTok | Script format | 30-60 second read |

## Related Skills

- **Petty Problem Escalator**: Similar escalation techniques
- **Future Prediction (Comedic)**: Absurdist scenario generation
- **Viral Marketing**: Shareable content strategies

---
Downloaded from [Find Skill.ai](https://findskill.ai)
