---
name: threads-viral-content-decoder
version: 1.0.0
---

# Initialization

Threads Viral Content Decoder helps you reverse-engineer engagement mechanics on Meta's Threads platform. Understand algorithm ranking signals, identify viral content patterns in your niche, and develop conversation-first content strategies that drive meaningful interactions.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with comprehensive Threads strategy instructions

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None

## Post-Init Steps

### Claude Code
```bash
cp -r threads-viral-content-decoder/ ~/.claude/skills/threads-viral-content-decoder/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant's system prompt or conversation

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{posting_frequency}}` | `5` | Target posts per week (3-10 range) |
| `{{conversation_starter_ratio}}` | `0.60` | Percentage of reply-focused posts (0.0-1.0) |
| `{{peak_posting_hours}}` | `9am, 12pm, 6pm` | Optimal posting times for audience |
| `{{hashtag_density}}` | `2` | Topic tags per post (0-5 range) |
| `{{image_inclusion_ratio}}` | `0.40` | Percentage of posts with visuals (0.0-1.0) |
| `{{cross_platform_promo_budget}}` | `0.20` | Instagram posts for Threads promotion |

## Core Capabilities

1. **Algorithm Analysis** - Decode how Threads ranks posts based on engagement signals, recency, user interests, and content attributes
2. **Viral Pattern Recognition** - Identify trending formats, conversation starters, and content themes that drive high engagement
3. **Content Strategy Optimization** - Create platform-specific content calendars and posting schedules
4. **Creator Benchmarking** - Compare performance against successful creators using engagement metrics
5. **Engagement Prediction** - Predict likelihood of posts going viral based on content analysis
6. **Cross-Platform Amplification** - Leverage Instagram audience to boost Threads visibility
7. **Analytics Interpretation** - Understand metrics and identify performance patterns

## Example Usage

```
I'm a productivity coach with 8K followers on Threads, primarily attracting
entrepreneurs aged 25-40. My engagement rate is 4.2%, but I want to reach 8%
within 60 days. Analyze top productivity creators with 50K-200K followers.
What post formats get the most replies? Create a 30-day content calendar
with conversation starters that would resonate with my audience.
```

## Key Concepts

- **For You Feed** - Algorithmic feed with personalized recommendations
- **Engagement Velocity** - How quickly posts receive interactions after posting
- **Conversation Starter** - Content designed to prompt user responses
- **Recency Bias** - Algorithm preference for newer posts
- **Meaningful Interaction** - Effort-based engagement (comments > likes)
- **Topic Tags** - Categorical labels for discoverability

## Research Sources

Based on analysis from:
- ContentStudio Threads Algorithm Guide (2025)
- RecurPost Threads Algorithm Technical Analysis
- Meta Official Engagement Insights
- Sprout Social Threads Analytics Guide
- Academic research on social media content optimization

---
Downloaded from [Find Skill.ai](https://findskill.ai)
