---
name: video-hook-generator
version: 1.0.0
---

# Initialization

Generate 10 compelling video opening lines using psychological triggers, copywriting
frameworks, and platform-specific optimization for YouTube, TikTok, Instagram Reels,
and LinkedIn.

## Structure

- `SKILL.md` - Main skill prompt with 15 hook archetypes and 5 workflows

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r video-hook-generator/ ~/.claude/skills/video-hook-generator/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (everything below the second `---`)
3. Paste into your AI assistant as a system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `video_title` | "How to Build Passive Income in 90 Days" | The proposed title or headline of the video |
| `video_concept_angle` | "step-by-step tutorial" | The unique angle (contrarian, insider secrets, beginner-friendly, etc.) |
| `target_platform` | "YouTube" | Distribution platform: YouTube, TikTok, Instagram Reels, LinkedIn |
| `target_audience_segment` | "busy professionals aged 28-45" | Specific demographic or psychographic profile |
| `primary_emotion_trigger` | "Curiosity" | Main psychological hook: Curiosity, Urgency, Authority, Social Proof, Fear, Empowerment |
| `desired_tone` | "Conversational" | Voice and style: Conversational, Professional, Casual/Witty, Educational |

## Quick Start

After installing, start with:

```
I'm creating a YouTube video titled "5 AI Tools Every Marketer Needs in 2025"
targeting marketing managers. Generate 10 hook variations focusing on authority
and FOMO with a professional but personable tone.
```

## Hook Archetypes Included

1. **Curiosity Gap** - Partial reveals that create tension
2. **Question** - Direct questions about pain points
3. **Contrarian** - Challenges conventional wisdom
4. **Benefit-Led** - Leads with transformation/result
5. **Story** - Opens with narrative element
6. **Statistic** - Leads with surprising data
7. **Challenge** - Positions viewer against obstacle
8. **Proof** - Leads with demonstrated results
9. **Warning** - Alerts to danger or mistake
10. **Promise** - Makes specific, achievable promise
11. **Secret/Insider** - Positions info as exclusive
12. **Comparison** - Contrasts two approaches
13. **Paradigm Shift** - Introduces new thinking
14. **Time-Pressure** - Creates urgency
15. **Relatability** - Connects through shared experience

## Platform Guidelines

| Platform | Optimal Length | Tone |
|----------|----------------|------|
| YouTube | 15-25 words | Conversational to Educational |
| TikTok | 8-15 words | Casual, punchy, trendy |
| Instagram Reels | 10-18 words | Aspirational, visual |
| LinkedIn | 20-35 words | Professional, value-driven |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
