---
name: writers-block-buster
version: 1.0.0
---

# Writer's Block Buster - Initialization

A niche-specific prompt skill that diagnoses the root cause of writer's block and delivers targeted micro-prompts to reignite creative momentum across fiction, blogging, technical writing, and academic work.

## What This Skill Does

Unlike generic "just write" advice, this skill:

1. **Diagnoses block type** - Identifies whether you're facing perfectionism paralysis, direction void, momentum loss, overwhelm, research gaps, or voice confusion
2. **Delivers niche-specific prompts** - Fiction writers get different prompts than bloggers or technical writers
3. **Calibrates to session length** - 10-minute sprints vs. 2-hour deep sessions
4. **Uses psychological techniques** - Permission-based prompts, "write badly" challenges, constraint-based creativity
5. **Tracks what works** - Remembers which prompts helped for future sessions

## Structure

```
writers-block-buster/
├── SKILL.md       # Main skill prompt (copy to AI assistant)
└── INIT.md        # This file - setup instructions
```

## Files to Generate

None required. This is a prompt-only skill.

## Installation

### Claude Code (Recommended)

```bash
# Copy the skill to your Claude skills directory
cp -r writers-block-buster/ ~/.claude/skills/writers-block-buster/
```

Then reference in conversations: "Use my writers-block-buster skill"

### Claude Projects

1. Create a new Project or open existing
2. Go to Project Knowledge
3. Upload `SKILL.md` as a knowledge file
4. Start conversation referencing the skill

### ChatGPT Custom Instructions

1. Go to Settings → Personalization → Custom Instructions
2. Copy the content from `SKILL.md` (after the frontmatter `---`)
3. Paste into "How would you like ChatGPT to respond?"
4. Save

### ChatGPT GPTs

1. Create New GPT → Configure
2. Name: "Writer's Block Buster"
3. Instructions: Paste full `SKILL.md` content
4. Conversation starters:
   - "I'm stuck on my novel's opening chapter"
   - "I have a blog post idea but can't find the right angle"
   - "I haven't touched my project in two weeks and can't get back into it"

### Gemini

1. Start new conversation
2. Paste `SKILL.md` content as initial message
3. Follow with: "Use these instructions to help me with writer's block"

### Other AI Assistants

1. Open `SKILL.md` in a text editor
2. Copy all content after the frontmatter section (after second `---`)
3. Paste as system prompt or initial context

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{niche_type}}` | `fiction` | Primary writing domain: fiction, non-fiction, blog, technical, academic, copywriting |
| `{{genre_or_subtype}}` | `` | Specific genre (romance, sci-fi) or content type (tutorial, case study) |
| `{{block_type}}` | `unknown` | Root cause: perfectionism, direction, momentum, research, overwhelm, voice |
| `{{session_duration}}` | `30-60min` | Available time: 5-10min, 15-30min, 30-60min, 2+hours |
| `{{voice_tone}}` | `professional` | Writer's tone: professional, conversational, literary, technical, humorous |
| `{{project_stage}}` | `early_draft` | Stage: brainstorm, outline, early_draft, mid_draft, revision, final_polish |

## Quick Start Prompts

**Perfectionism Block:**
> "I keep writing sentences and deleting them. Nothing sounds good enough."

**Direction Block:**
> "I have 5 different angles for this blog post and can't decide which one."

**Momentum Block:**
> "I haven't written in 3 weeks. I can't get back into my novel."

**Overwhelm Block:**
> "My book project feels too big. I don't know where to focus today."

**Research Block:**
> "I need to write about 19th century medicine but I don't know enough yet."

**Voice Block:**
> "This is for a client and I can't match their brand voice."

## Block Types Reference

| Block Type | Key Symptom | Remedy Approach |
|------------|-------------|-----------------|
| Perfectionism | "I delete everything I write" | Permission prompts, "write badly" challenges |
| Direction | "Too many options, can't choose" | Angle clarification, audience definition |
| Momentum | "Been away, can't re-enter" | Re-entry summaries, warm-up sprints |
| Overwhelm | "Project feels too big" | Single-scene focus, MVP framing |
| Research | "Need to look things up first" | Placeholder strategy, write-around techniques |
| Voice | "Doesn't sound right" | Voice samples, constraint exercises |

## Expected Outcomes

- **Minimum**: Any new words written (even 50)
- **Target**: Completion of one scene/section
- **Bonus**: Clear momentum for next session

The goal is movement, not masterpiece. Perfect is the enemy of done.

## Troubleshooting

**Skill doesn't engage with block type:**
Explicitly state your block: "I think this is a perfectionism block because..."

**Prompts feel too generic:**
Provide more niche context: "I write cozy mysteries with amateur sleuth protagonists for readers 45+"

**Still stuck after prompts:**
Ask for the "Emergency Unblock Protocol" - radically lowered bar with celebration of any output.

## Related Skills

- `fiction-writing-partner` - For ongoing fiction collaboration
- `storytelling-coach` - For narrative structure help
- `blog-post-writer` - For structured blog content
- `cognitive-reframing-guide` - For perfectionism mindset work
- `habit-tracker` - For building consistent writing habits

---

Downloaded from [Find Skill.ai](https://findskill.ai)
