---
name: youtube-content-strategy-architect
version: 1.0.0
---

# Initialization

Design comprehensive YouTube content strategies using the Help/Hub/Hero framework, with SEO optimization, monetization planning, and analytics-driven growth for channels of any size.

## Structure

This skill contains:
- `SKILL.md` - Main skill prompt with complete YouTube strategy framework

## Files to Generate

None (prompt-only skill - copy SKILL.md content directly)

## Dependencies

None required. Optional tools for enhanced workflow:
- VidIQ or TubeBuddy (YouTube SEO/analytics)
- Canva or Adobe Express (thumbnail creation)
- YouTube Studio (analytics access)

## Post-Init Steps

### Claude Code
```bash
cp -r youtube-content-strategy-architect/ ~/.claude/skills/youtube-content-strategy-architect/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after the frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant's system prompt or chat

## Compatibility

Tested with: claude, chatgpt, gemini, copilot

## Core Capabilities

This skill enables:
- **Audience Research**: Define target demographics, create viewer personas, analyze competitors
- **Content Planning**: Build 3-12 month calendars using Help/Hub/Hero framework
- **SEO Optimization**: Keyword research, title/description optimization, thumbnail best practices
- **Monetization Strategy**: YPP requirements, sponsorships, memberships, affiliate marketing
- **Analytics Interpretation**: Understand Watch Time, CTR, retention curves, traffic sources
- **Cross-Platform Repurposing**: Adapt YouTube content for Shorts, TikTok, blogs, newsletters
- **Community Building**: Engagement strategies, memberships, live streaming

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_keyword_search_volume}}` | `10000` | Minimum monthly searches for Help content keywords |
| `{{content_mix_percentage}}` | `help:50, hub:40, hero:10` | Content type allocation |
| `{{upload_frequency_per_week}}` | `1` | Weekly upload frequency |
| `{{target_ctr_percentage}}` | `4.5` | Goal click-through rate |
| `{{audience_retention_target}}` | `0.55` | Target avg view duration (as %) |
| `{{hero_content_promotion_lead_time_days}}` | `14` | Days before hero launch to promote |
| `{{monetization_threshold_strategy}}` | `2x_path` | YPP focus strategy |

## Example Usage

```
"I'm launching a tech review channel targeting developers aged 25-40.
My goal is 10K subscribers in 12 months with 5 hours/week available.
Create a complete content strategy with:
1. Keyword research for 15 Help content topics
2. A Hub series concept for subscriber retention
3. 3-month content calendar
4. Thumbnail and title templates
5. Monetization roadmap"
```

## Research Sources

- YouTube Creator Playbook for Brands (Google)
- YouTube Creators Hub (Official)
- Hootsuite YouTube Algorithm Guide
- YouTube Creator Academy
- Influencer Marketing Hub Monetization Guide

---
Downloaded from [Find Skill.ai](https://findskill.ai)
