---
name: awkward-situation-responder
version: 1.0.0
description: Ready-to-use scripts for awkward social situations
author: FindSkill.ai
license: MIT
---

# Awkward Situation Responder — Initialization

## Overview

This is a prompt-only skill that provides word-for-word scripts for uncomfortable social moments. Every response comes in multiple tones so you can pick what fits your personality and the situation.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with situation library and response scripts
- `INIT.md` — This initialization guide

## Directory Structure

```
awkward-situation-responder/
├── SKILL.md    # Main skill with scripts for 20+ situation types
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Describe your awkward situation

### ChatGPT / Gemini / Copilot
Same process — paste and describe what happened.

## Core Capabilities

1. **Situation Matching** — Identifies the type of awkwardness and pulls relevant scripts
2. **Multi-Tone Responses** — Graceful, humorous, firm, and assertive options for every scenario
3. **Word-for-Word Scripts** — Exact phrases to use, not vague advice
4. **Body Language Coaching** — How to deliver the script (tone, eye contact, posture)
5. **Follow-Through Guidance** — What to do immediately after responding
6. **Prevention Tips** — How to avoid the situation next time
7. **Universal Toolkit** — All-purpose phrases that work in any awkward moment
8. **Boundary Setting** — When awkward crosses into inappropriate

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `situation` | *(empty)* | The awkward situation you're dealing with |
| `setting` | `social gathering` | Where this is happening |
| `tone_preference` | `graceful` | How you want to come across |

## Usage Examples

### Example 1: Nosy Aunt at Thanksgiving

**User:** "My aunt keeps asking when I'm having kids in front of the whole family."

**AI Response:** Provides 4 scripts — graceful redirect ("I'll let you know!"), humor ("Taking applications!"), firm boundary ("That's something I keep private"), and power move ("Why do you ask?" with eye contact).

### Example 2: Forgot Client's Name

**User:** "I've met this client 3 times and I can't remember her name. She's coming to a meeting tomorrow."

**AI Response:** Provides the introduction trick, the phone number trick, and the honest approach with exact wording and timing.

### Example 3: Boss Took Credit

**User:** "My manager presented my idea as his own in a meeting with senior leadership."

**AI Response:** Provides graceful in-meeting response, documented email follow-up template, and private conversation script with body language tips.

## Situations Covered

- Nosy questions (marriage, kids, money, weight, relationships)
- Forgotten names / wrong name corrections
- Physical mishaps (spills, trips, body noises)
- Workplace awkwardness (credit stealing, reply-all, spacing out)
- Social gathering problems (being ignored, disagreements, bad gifts)
- Saying something offensive accidentally
- Digital mishaps (accidental likes, wrong-person texts)
- Uninvited opinions and unsolicited advice
- Being caught in a lie or exaggeration
- Walking into the wrong room/conversation

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Scripts feel too formal | Ask for "casual" or "humor" tone specifically |
| Situation isn't in the library | Describe it — the AI adapts to any scenario |
| Need a response for a text/DM | Specify "digital" and the AI adjusts for written format |
| Boundary violation (not just awkward) | Tell the AI it's serious — it'll shift from humor to firm boundaries |

## Best Practices

1. **Pick ONE script** — Don't try to use all four in one response
2. **Practice out loud** — Say the script before the event
3. **Match the tone to YOU** — If you're not funny, don't use humor scripts
4. **Pause before responding** — A beat of silence is better than a panicked answer
5. **Body language matters** — A warm smile changes how any script lands
6. **Let it go after** — Don't replay the moment. You handled it.

---
Downloaded from [Find Skill.ai](https://findskill.ai)
