---
name: bio-optimizer
version: 1.0.0
---

# Bio Optimizer - Initialization

Transform unclear, generic bios into compelling, platform-specific descriptions that instantly communicate your value. Works across LinkedIn, Instagram, Twitter, dating apps, and personal websites.

## Package Contents

```
bio-optimizer/
├── SKILL.md    # Main skill prompt (500+ lines)
└── INIT.md     # This initialization file
```

## Structure

- `SKILL.md` - Complete bio optimization prompt with platform-specific strategies, hook formulas, troubleshooting guides, and output templates

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code Installation

```bash
# Copy skill to Claude Code skills directory
cp -r bio-optimizer/ ~/.claude/skills/bio-optimizer/
```

### Other AI Assistants (ChatGPT, Gemini, Copilot)

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of your conversation
4. Begin by describing your current bio situation or what platform you need help with

## Quick Start

After installation, start a conversation with:

```
I need help optimizing my bio for [platform]. Here's my current situation:
- Role: [your job title/profession]
- Target audience: [who you want to attract]
- Goal: [what action you want readers to take]
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `target_platform` | LinkedIn | Destination platform: LinkedIn, Instagram, Twitter, Tinder, personal_site |
| `bio_length` | medium | Desired length: short (50-100 words), medium (100-200), long (200+) |
| `tone` | professional | Communication style: professional, conversational, casual, humorous |
| `emphasis_area` | balanced | What to highlight: skills, achievements, personality, values |
| `audience_persona` | general | Target audience: hiring_managers, clients, partners, dating_prospects |
| `authenticity_level` | 0.8 | Balance between optimization (0) and genuine representation (1) |

## What This Skill Does

1. **Audits existing bios** using an 8-dimension clarity framework
2. **Generates platform-optimized bios** for LinkedIn, Instagram, Twitter, dating apps, and websites
3. **Creates attention-grabbing hooks** using 5 proven formula patterns
4. **Transforms vague descriptions** into clear value propositions
5. **Balances optimization with authenticity** based on your preferences
6. **Provides multiple versions** (length variants, tone variants, platform-specific)
7. **Includes keyword strategy** for discoverability without sounding spammy
8. **Troubleshoots common problems** like "I don't know what makes me unique"

## Platform Coverage

| Platform | Character Limit | Tone | Key Focus |
|----------|----------------|------|-----------|
| LinkedIn | 220 (headline) / 2,600 (about) | Professional | Keywords, credibility, CTA |
| Instagram | 150 | Casual/Personality | Scannability, emojis (1-2), link CTA |
| Twitter/X | 160 | Witty/Punchy | Personality, cleverness |
| Dating Apps | 300-500 | Authentic/Playful | Conversation hooks, humor |
| Personal Site | Unlimited | Flexible | Multiple lengths, storytelling |

## Example Outputs

**LinkedIn Headline:**
"AI/ML Leader | Fintech | $2M Revenue Impact | Building High-Performance Data Teams"

**Instagram Bio:**
"Body-positive fitness coach
Sustainable gains, no extreme diets
DM 'start' or tap the link"

**Dating App Bio:**
"PM by day, trail explorer by weekend. Cook suspect pasta. Animal rescue advocate. Let's debate hiking playlists."

---
Downloaded from [Find Skill.ai](https://findskill.ai)
