---
name: career-fulfillment-coach
version: 1.0.0
---

# Career Fulfillment Coach - Initialization

AI career coaching that aligns your work with your values and strengths. Assess job satisfaction, plan professional growth, prepare for interviews, and build accountability for career goals.

## Structure

```
career-fulfillment-coach/
├── SKILL.md      # Main skill prompt (comprehensive coaching system)
├── INIT.md       # This initialization file
└── index.md      # Hugo site metadata
```

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r career-fulfillment-coach/ ~/.claude/skills/career-fulfillment-coach/
```

### ChatGPT / Custom GPT
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT custom instructions or GPT builder

### Gemini
1. Open `SKILL.md`
2. Copy the skill content
3. Paste as system prompt or conversation starter

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant's system prompt or initial message

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{coaching_mode}}` | `assessment` | Type of session (assessment, goal_setting, interview_prep, accountability, exploration) |
| `{{career_stage}}` | `mid_career` | User's phase (early_career, mid_career, senior, executive, career_changer) |
| `{{satisfaction_level}}` | `dissatisfied` | Current satisfaction (fulfilled, content, dissatisfied, miserable, uncertain) |
| `{{urgency}}` | `exploring` | How quickly change is needed (exploring, actively_searching, urgent, crisis) |
| `{{focus_area}}` | `meaning` | Primary development area (skills, leadership, compensation, work_life, meaning) |
| `{{industry}}` | `other` | Industry context (tech, finance, healthcare, creative, nonprofit, other) |

## Example Usage

**Career assessment:**
```
I've been in marketing for 10 years but feel unfulfilled. The work pays well but feels empty. Help me figure out what's actually wrong.
```

**Interview preparation:**
```
[coaching_mode: interview_prep]

I have an interview for a Product Manager role at a Series B startup next week. I'm currently a Senior Analyst. Help me prepare.
```

**Accountability check-in:**
```
[coaching_mode: accountability]

Last week I committed to updating my resume and reaching out to 3 contacts. I only did the resume. Can we discuss what's blocking me?
```

**Values clarification:**
```
I don't know what I want from my career. Everyone else seems to have a clear direction. Can you help me figure out what matters to me?
```

## Core Capabilities

1. **5 Pillars Assessment** - Diagnose fulfillment gaps (Meaning, Mastery, Autonomy, Connection, Compensation)
2. **Values Discovery** - Structured exercises to identify core work values
3. **Strengths Assessment** - Recognize natural talents and competitive advantages
4. **SMART+ Goal Planning** - Create actionable career roadmaps with milestones
5. **Interview Practice** - Simulate interviews with real-time feedback
6. **Accountability Partnership** - Weekly check-ins with progress tracking
7. **Decision Frameworks** - "Stay or Go?" analysis, Career Change Calculator

## Session Types

| Mode | Use When |
|------|----------|
| Assessment | Feeling stuck, unfulfilled, or uncertain |
| Goal Setting | Know what you want, need a roadmap |
| Interview Prep | Preparing for specific interviews |
| Accountability | Ongoing support for career goals |
| Exploration | Don't know what you want yet |

## When to Use This Skill

- Feeling unfulfilled despite career success
- Uncertain about career direction
- Preparing for important interviews
- Considering a job change or career pivot
- Need accountability for professional goals
- Wanting to negotiate salary or promotion
- Burned out and questioning everything
- Seeking clarity on values and strengths

---
Downloaded from [Find Skill.ai](https://findskill.ai)
