---
name: career-sabbatical-planner
version: 1.0.0
---

# Initialization

The Career Sabbatical Planner skill helps professionals design, fund, negotiate, and execute strategic career breaks from 3-18 months. It provides comprehensive frameworks for financial runway calculation, employer negotiation, career risk mitigation, and successful workforce re-entry.

## Structure

- `SKILL.md` - Main skill prompt with complete sabbatical planning framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r career-sabbatical-planner/ ~/.claude/skills/career-sabbatical-planner/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything after the second `---`)
3. Paste into your AI assistant's system prompt or custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{sabbatical_duration_months}}` | `6` | Length of sabbatical in months (3-12 typical) |
| `{{monthly_burn_rate_usd}}` | `4500` | Total monthly expenses during sabbatical |
| `{{employer_pay_percentage}}` | `0` | Salary percentage continued (0=unpaid, 50=partial, 100=full) |
| `{{geographic_arbitrage_multiplier}}` | `1.0` | Cost of living adjustment (0.6 = 40% savings) |
| `{{job_search_runway_months}}` | `4` | Months reserved for job search and re-entry |
| `{{passive_income_monthly_usd}}` | `0` | Monthly passive income during sabbatical |
| `{{emergency_buffer_percentage}}` | `20` | Percentage of fund for emergencies (15-25% recommended) |

## Key Features

### Four Sabbatical Types
1. **Reset (3-6 months)** - Burnout prevention, perspective restoration
2. **Pivot (6-12 months)** - Career transition with retraining
3. **Launch (6-18 months)** - Business or project creation
4. **Freedom (Variable)** - Travel and personal exploration

### Core Frameworks
- **3-Account Strategy**: Emergency Buffer (20%), Operating Fund (70%), Re-entry Fund (10%)
- **18-24 Month Timeline**: Foundation → Acceleration → Preparation → Execution phases
- **Five Risk Mitigation Areas**: Momentum loss, skill stagnation, network atrophy, re-entry difficulties, hiring bias

### Planning Tools
- True cost calculator (accounts for 30-50% hidden costs)
- Geographic arbitrage analysis for runway extension
- Employer negotiation scripts and timing guidance
- Resume positioning and interview narrative templates
- 90-day post-return integration plan

## Usage Example

```
I'm a 35-year-old product manager making $145k/year with 8 years at my company.
I want to take a 9-month sabbatical to travel, learn Spanish, and explore
transitioning to UX research. My company doesn't have a formal sabbatical
policy but I have a good relationship with my VP. Monthly expenses are $5,200.
Help me plan this sabbatical including how to approach my employer, calculate
my financial runway, mitigate career risks, and position the break on my resume.
```

---
Downloaded from [Find Skill.ai](https://findskill.ai)
