---
name: cover-letter-hook-writer
version: 1.0.0
---

# Initialization

Generate compelling opening sentences for cover letters that capture recruiter attention in 5-10 seconds. This skill focuses specifically on the "hook"—the critical first 2-3 sentences that determine whether a recruiter continues reading your application.

## What This Skill Does

- Creates multiple hook variations with different angles (achievement, mission, problem-solving, narrative)
- Adapts tone for different industries (tech, finance, nonprofit, healthcare, creative)
- Handles special situations (career changes, employment gaps, referrals, entry-level)
- Provides explanations of why each hook works
- Offers personalized recommendations based on your situation

## Structure

- `SKILL.md` - Main skill prompt with complete hook writing framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r cover-letter-hook-writer/ ~/.claude/skills/cover-letter-hook-writer/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant (Claude, ChatGPT, Gemini, Copilot)
4. Provide: job posting, your achievements, and why you're interested in the company

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `job_description` | `[Paste job description]` | Full text of the job posting |
| `candidate_background` | `[Your top 3-5 achievements with numbers]` | Resume highlights or key achievements |
| `tone_style` | `professional_friendly` | Hook tone: formal, professional_friendly, casual_confident, creative |
| `focus_angle` | `balanced` | Emphasis: accomplishment, mission_aligned, problem_solving, innovation, relationship |
| `variation_count` | `3` | Number of hook variations to generate (1-7) |
| `company_research` | `[Optional]` | Additional context about company (news, culture, initiatives) |

## Quick Start Example

After loading the skill, try:

```
I'm applying for a Product Manager role at Stripe. Here's the job description:
[paste job posting]

My background:
- 5 years as PM at fintech startup
- Led payment feature used by 50K merchants, grew transaction volume 180%
- Built team from 3 to 12 people

I'm interested in Stripe because I've used their API for years and love their developer-first approach.

Please generate 3 hook variations—one achievement-focused, one mission-aligned, and one problem-solving.
```

## What You'll Receive

For each hook, the AI will provide:
1. **The hook itself** (2-3 sentences)
2. **Why it works** (brief explanation)
3. **Best for** (which situations/companies)

Plus a recommendation on which hook to use for your specific application.

## Tips for Best Results

1. **Be specific about achievements** - Include numbers, percentages, dollar amounts
2. **Share genuine interest** - What actually draws you to this company?
3. **Mention tone preference** - Startups vs. corporate, formal vs. casual
4. **Include any special circumstances** - Career change, gap, referral, etc.
5. **Research the company** - Recent news, initiatives, or challenges help create better hooks

---
Downloaded from [Find Skill.ai](https://findskill.ai)
