---
name: first-day-prep-guide
version: 1.0.0
description: Prepare for your first day at a new job with a complete preparation plan
author: FindSkill.ai
license: MIT
---

# First Day Prep Guide — Initialization

## Overview

This is a prompt-only skill for preparing for a first day at a new job. It creates personalized checklists, introduction scripts, question lists, and day-of timelines.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with preparation templates and checklists
- `INIT.md` — This initialization guide

## Directory Structure

```
first-day-prep-guide/
├── SKILL.md    # Main skill with checklists and templates
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude about your new role, company type, and start date

### ChatGPT / Gemini / Copilot
Same process — paste and describe your upcoming first day.

## Core Capabilities

1. **Pre-Arrival Checklist** — Logistics, wardrobe, tech, and mental preparation
2. **30-Second Introduction** — Natural self-intro script personalized to your role
3. **Smart Questions Library** — Questions for manager, colleagues, and HR
4. **Day-Of Timeline** — Hour-by-hour plan from morning to end of day
5. **Name Memory System** — Techniques for remembering 10-30 new names
6. **First Week Goals** — Day-by-day progression from observe to contribute
7. **Situation-Specific Tips** — Remote, hybrid, corporate, startup, first job
8. **Anxiety Management** — Practical techniques for managing first-day nerves

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `role` | `` | The job title or role you're starting |
| `company_type` | `` | Type of company (startup, corporate, remote, hybrid) |
| `start_date` | `` | When your first day is |

## Usage Examples

### Example 1: Corporate Job

**User:** "Starting as a marketing coordinator at a tech company next Monday. It's hybrid."

**AI Response:** Creates a complete prep plan with tech company dress code tips, hybrid-specific advice, marketing team intro script, and a first-week timeline.

### Example 2: Career Change

**User:** "I'm switching from teaching to UX design at a startup. Never worked in tech."

**AI Response:** Provides startup culture prep, tech industry norms, career-changer introduction template, and industry-specific questions to ask.

### Example 3: First Job Ever

**User:** "Just graduated and starting my first job ever next week. I'm really nervous."

**AI Response:** Extra reassurance, basic workplace norms guide, detailed wardrobe advice, and anxiety management techniques.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Don't know the dress code | Ask HR before day 1, or dress one level above casual |
| Don't know anyone | That's normal — everyone expects you to be new |
| Nervous about introductions | Practice your 30-second intro 3 times out loud |
| Don't know what to bring | ID, offer letter, notebook, pen, lunch money, phone |
| Worried about mistakes | Nobody expects perfection on day 1 — curiosity matters more |

## Best Practices

1. **Do a practice commute** — drive/transit the route at rush hour before day 1
2. **Research your team** — look up 5-6 people on LinkedIn for names and faces
3. **Prepare your intro** — practice it out loud until it feels natural
4. **Bring a notebook** — writing things down shows engagement
5. **Accept all lunch invitations** — relationship building > solo productivity
6. **Send a thank-you** — email your manager at end of day 1

---
Downloaded from [Find Skill.ai](https://findskill.ai)
