---
title: "First Day Prep Guide"
description: "Prepare for your first day at a new job with a complete checklist covering logistics, introductions, questions to ask, and how to make a great impression."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "role"
    default: ""
    description: "The job title or role you're starting"
  - name: "company_type"
    default: ""
    description: "Type of company (startup, corporate, remote, hybrid)"
  - name: "start_date"
    default: ""
    description: "When your first day is"
---

# First Day Prep Guide

A skill that creates personalized first-day preparation plans for new jobs. Covers logistics, wardrobe, introductions, smart questions to ask, name memory techniques, and anxiety management to help you walk in confident and prepared.

## When to Use This Skill

- Starting a new job and want to make a great first impression
- Feeling anxious about your first day and need a structured plan
- Switching to a new type of company (startup, corporate, remote)
- Career change and unsure about industry norms
- First job ever and don't know what to expect

## Key Features

### Pre-Arrival Checklist
- Logistics (time, location, parking, who to ask for)
- Wardrobe (dress code, outfit prep)
- Tech prep (devices, apps, video call setup)
- Mental prep (company research, team LinkedIn review)

### 30-Second Introduction Template
- Natural, confident self-intro script
- Role-specific customization
- Tips for delivery

### Smart Questions Library
- Questions for your manager (success criteria, priorities)
- Questions for colleagues (team culture, tips)
- Questions for HR (benefits, resources)
- Questions to avoid on day 1

### Day-Of Timeline
- Morning routine through end of day
- 80/20 listening rule
- Lunch strategy
- End-of-day wrap-up

### Situation-Specific Advice
- Remote / work from home
- Hybrid workplace
- Corporate / large company
- Startup
- First job / career change

### First Week Goals
- Day-by-day progression plan
- From "survive and observe" to "make small contributions"
- Week-1 summary email template

---
Downloaded from [Find Skill.ai](https://findskill.ai)
