---
name: internal-transfer-pitch
version: 1.0.0
---

# Initialization

Navigate internal job transfers within your organization while minimizing retaliation risk from your current manager. This skill provides timing strategies, conversation scripts, policy analysis guidance, and relationship-building tactics for successful team moves.

## Structure

- `SKILL.md` - Main skill prompt with complete strategic guidance

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r internal-transfer-pitch/ ~/.claude/skills/internal-transfer-pitch/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or as a conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{tenure_months}}` | `14` | Months in current role (most companies require 6-12 minimum) |
| `{{manager_relationship}}` | `neutral` | Quality of relationship with current manager (poor, neutral, good) |
| `{{company_policy}}` | `formal` | Transfer policy type (formal, informal, auto_notify) |
| `{{urgency_level}}` | `medium` | How time-sensitive is the opportunity (low, medium, high) |
| `{{performance_standing}}` | `meets_expectations` | Current performance rating (exceeds, meets_expectations, below) |
| `{{disclosure_risk_tolerance}}` | `low` | Comfort with manager discovering intent early (low, medium, high) |

## Example Usage

After loading the skill, provide your situation:

```
I've been in my current role for 14 months at a mid-size tech company. My manager
micromanages and has retaliated against team members who tried to transfer before.
I'm interested in moving to the Product team but don't know anyone there. I have a
"meets expectations" performance rating. I want to minimize the risk of my manager
finding out until I absolutely have to tell them.
```

The AI will:
1. Assess your situation against the key risk factors
2. Recommend the appropriate workflow (likely Conservative Approach)
3. Provide week-by-week action steps
4. Give you specific scripts for each conversation
5. Help you prepare for manager objections

## Key Workflows Included

1. **Conservative Approach** - Maximum secrecy for poor manager relationships
2. **Transparent Approach** - Leverage good manager as advocate
3. **Rapid Opportunity** - Fast-track process for time-sensitive openings
4. **Network-First** - Long-term relationship building (6-12 months)

## Industry-Specific Guidance

The skill includes tailored advice for:
- Large Tech (Amazon, Google, Meta, Microsoft)
- Consulting/Professional Services (Big 4, McKinsey)
- Financial Services (Banks, Asset Managers)
- Federal Government/Public Sector
- Small/Mid-Size Companies

---
Downloaded from [Find Skill.ai](https://findskill.ai)
