---
name: job-application-tracker
version: 1.0.0
description: Organize your job search with structured tracking and follow-up systems
author: FindSkill.ai
license: MIT
---

# Job Application Tracker — Initialization

## Overview

This is a prompt-only skill for organizing job searches. It creates structured tracking systems, follow-up schedules, networking logs, and search analytics.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with tracker templates and follow-up systems
- `INIT.md` — This initialization guide

## Directory Structure

```
job-application-tracker/
├── SKILL.md    # Main skill with tracking templates
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude about your job search and what you need to track

### ChatGPT / Gemini / Copilot
Same process — paste and describe your job search situation.

## Core Capabilities

1. **Master Application Tracker** — Status pipeline with all essential columns
2. **Follow-Up System** — Day 7/14/21 timeline with email templates
3. **Weekly Review Ritual** — 30-minute Sunday check-in template
4. **Networking Tracker** — Log contacts, conversations, and next steps
5. **Interview Prep Checklist** — Company-specific preparation tracker
6. **Offer Comparison Table** — Side-by-side offer analysis
7. **Search Analytics** — Response rates, channel effectiveness, trends
8. **Quality Checklist** — Pre-submit verification for every application

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `job_type` | `` | The type of role you're looking for |
| `search_stage` | `just starting` | Where you are in your job search |
| `weekly_goal` | `5-10` | How many applications per week |

## Usage Examples

### Example 1: New Job Search

**User:** "I'm starting to look for product manager roles. Help me set up a tracking system."

**AI Response:** Creates a complete tracker template with columns, status codes, and a weekly review ritual tailored to PM roles.

### Example 2: Mid-Search Organization

**User:** "I've applied to 15 companies and can't remember which ones. Help me organize."

**AI Response:** Helps them reconstruct their application history, identifies overdue follow-ups, and sets up a system going forward.

### Example 3: Multiple Offers

**User:** "I have 3 offers and need to compare them."

**AI Response:** Creates a detailed comparison table including total compensation, benefits, culture, growth potential, and commute factors.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Too many columns to track | Start with the 6 essentials: Company, Role, Date, Status, Next Step, Contact |
| Forgetting to update | Set a weekly 30-min calendar reminder for Sunday review |
| Low response rate | Check benchmarks — if below average, review resume/approach |
| Overwhelmed by volume | Focus on quality — 5 tailored apps beat 20 generic ones |
| Lost motivation | Review your analytics — seeing progress in numbers helps |

## Best Practices

1. **Update immediately** — log every application the moment you submit
2. **Follow up consistently** — Day 7 follow-up boosts callbacks by 33%
3. **Quality over quantity** — tailored applications get 78% higher response rates
4. **Track networking separately** — 70-85% of jobs come through connections
5. **Review weekly** — Sunday evening check-in prevents Monday surprises
6. **Celebrate small wins** — every callback and interview is progress

---
Downloaded from [Find Skill.ai](https://findskill.ai)
