---
name: linkedin-cringe-remover
version: 1.0.0
---

# LinkedIn Cringe Remover - Initialization

Transform corporate-speak LinkedIn profiles and posts into authentic, human-sounding content by eliminating buzzwords, jargon, and robotic patterns while preserving professional credibility.

## What This Skill Does

- Detects and eliminates corporate buzzwords and cliches
- Identifies AI-generated writing patterns
- Rewrites content to sound like a real person
- Preserves achievements and credibility while humanizing tone
- Provides before/after comparisons with explanations

## Package Structure

```
linkedin-cringe-remover/
├── SKILL.md     # Main skill prompt (copy into AI assistant)
└── INIT.md      # This initialization file
```

## Files to Generate

None required - this is a prompt-only skill.

## Installation

### Claude Code / Claude Desktop
```bash
# Copy skill folder to Claude skills directory
cp -r linkedin-cringe-remover/ ~/.claude/skills/linkedin-cringe-remover/

# Or add to your project's .claude/skills/ directory
cp -r linkedin-cringe-remover/ .claude/skills/linkedin-cringe-remover/
```

### ChatGPT / Gemini / Copilot / Other AI Assistants
1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or first message

## Quick Start

After installing, start a conversation with:

```
"My LinkedIn bio sounds too corporate. Here it is:

[Paste your current bio]

Make it sound human without losing my credibility."
```

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{formality_level}}` | `professional_casual` | Tone: formal, professional_casual, casual_authentic |
| `{{buzzword_sensitivity}}` | `aggressive` | How strict: conservative, moderate, aggressive |
| `{{personality_injection_level}}` | `medium` | Personality amount: minimal, medium, maximum |
| `{{target_audience_type}}` | `general_professional` | Audience: recruiter, clients, peers, executives |
| `{{vulnerability_depth}}` | `medium` | Vulnerability: minimal, medium, high |
| `{{preserve_metrics}}` | `true` | Keep quantified achievements intact |

## Example Usage

**Input:**
```
"Passionate thought leader and innovative strategist with 15+ years of experience leveraging cutting-edge solutions to drive paradigm-shifting results in digital transformation."
```

**Output:**
```
"I've spent 15 years helping companies stop talking about digital transformation and actually do it. Currently at [Company] where I led the migration that saved us $2M/year. Let's connect if you're dealing with legacy tech debt."
```

## Cringe Tiers Reference

**Tier 1 - Always Remove:**
- Thought leader, Evangelist, Guru, Ninja
- Synergize, Leverage, Paradigm shift
- Move the needle, Circle back

**Tier 2 - Context-Dependent:**
- Innovative (only with specific examples)
- Strategic (needs concrete reference)
- Results-driven (show results instead)

**Tier 3 - AI Detection Signals:**
- Delve, Meticulous, Multifaceted
- Uniform sentence rhythm
- Overused adverbs

## Best For

- LinkedIn About sections / bios
- LinkedIn headlines (120 char)
- LinkedIn posts and articles
- Job experience descriptions
- Connection request messages
- Personal brand development

## Related Skills

- LinkedIn Profile Optimizer - SEO and keyword optimization
- LinkedIn Post Writer - Content creation
- Brand Voice - Develop consistent voice
- Personal Brand Clarity Session - Define your identity

---
Downloaded from [Find Skill.ai](https://findskill.ai)
