---
name: performance-review-defender
version: 1.0.0
---

# Performance Review Defender - Initialization

A specialized language translator that converts casual, humble work descriptions into high-impact corporate statements aligned with OKRs and KPIs.

## Package Structure

```
performance-review-defender/
├── SKILL.md     # Main skill prompt (500+ lines)
└── INIT.md      # This file
```

## What This Skill Does

- **Casual-to-Formal Translation**: Transforms "I fixed the bug" into "Resolved critical system vulnerability, reducing downtime risk by X%"
- **OKR/KPI Mapping**: Links individual tasks to company objectives (Revenue, Efficiency, Risk, Satisfaction)
- **Impact Quantification**: Injects metric placeholders where measurements are missing
- **STAR Formatting**: Structures achievements into Situation-Task-Action-Result format
- **Tone Calibration**: Adjusts from humble to assertive to executive
- **Power Verb Injection**: Replaces weak verbs (helped, worked on) with strong verbs (spearheaded, delivered)

## Files to Generate

None - this is a prompt-only skill.

## Installation

### Claude Code

```bash
# Copy skill to Claude Code skills directory
cp -r performance-review-defender/ ~/.claude/skills/performance-review-defender/

# Or create symlink for easier updates
ln -s "$(pwd)/performance-review-defender" ~/.claude/skills/performance-review-defender
```

### ChatGPT / Gemini / Copilot

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant's custom instructions or as a prompt

### As System Prompt

Copy the content of SKILL.md and use it as a system prompt in any AI application.

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_role}}` | `Software Engineer` | Your job title - controls output depth |
| `{{target_metric}}` | `Efficiency` | Value focus: Efficiency, Revenue, Quality, Risk, Culture |
| `{{tone_intensity}}` | `Assertive` | Language style: Humble_Confidence, Assertive, Executive |
| `{{company_goals}}` | `` | Your company's OKRs for strategic alignment |
| `{{quantify_placeholder}}` | `true` | Insert [X%] placeholders for missing metrics |

## Quick Start Examples

### Basic Usage

```
Act as Performance Review Defender.

I'm a Product Designer. Here are my casual achievements:
- Made the checkout flow better
- Helped with the design system
- Did user testing for the new feature
```

### With OKR Alignment

```
Act as Performance Review Defender.

Role: Senior Software Engineer
Company Goal: "Improve platform reliability to 99.99% uptime"

Casual achievement: "Fixed that memory leak that was causing crashes"

Task: Translate this and show OKR alignment.
```

### STAR Format Request

```
Act as Performance Review Defender.

I need a STAR format entry for my promotion packet.

Story: "I was the only one who could figure out why the payments were randomly failing. Turned out to be a timezone bug. Took me 3 days but I found it and fixed it. Saved us from losing a major client."

Audience: VP of Engineering
```

### Promotion Packet Builder

```
Act as Performance Review Defender.

Build a promotion packet for me:
- Role: Senior Data Analyst → Staff Data Analyst
- Period: Q1-Q4 2025

Achievements:
1. Built the new dashboard everyone uses
2. Trained 3 new analysts
3. Saved a major report from being wrong
4. Automated the monthly metrics email
5. Presented to the exec team twice
```

## Key Frameworks Included

### Laszlo Bock Formula
```
Accomplished [X] as measured by [Y] by doing [Z]
```

### The "So What?" Test
Keep asking "So what?" until you reach a dollar figure or business metric.

### Value-Delta Calculation
```
Before: 5 days → After: 2 days → Delta: 3 days saved
Annual Impact: 3 × 52 = 156 days/year
Dollar Value: 156 × $500/day = $78,000 saved
```

### Cost of Delay
For defensive/preventative work without obvious positive metrics.

## Power Verbs Reference

**Use:** Spearheaded, Orchestrated, Delivered, Optimized, Architected, Drove, Scaled

**Avoid:** Helped, Worked on, Was responsible for, Handled, Assisted, Dealt with

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Output too generic | Provide more specific context about your role and industry |
| Missing quantification | Use placeholder format: "estimated [X]% improvement" |
| Too aggressive tone | Set `tone_intensity` to `Humble_Confidence` |
| Doesn't match company style | Include sample review language from your company |

## Related Skills

- **salary-negotiation-coach** - Use polished achievements to negotiate compensation
- **resume-job-search-coach** - Apply same translation to resume bullets
- **linkedin-profile-optimizer** - Extend corporate language to professional brand
- **goal-framework-strategist** - Set goals that translate to future achievements

---
Downloaded from [Find Skill.ai](https://findskill.ai)
