---
name: personal-swot-analysis
version: 1.0.0
description: Guided personal SWOT analysis for career decisions and self-assessment
author: FindSkill.ai
license: MIT
---

# Personal SWOT Analysis — Initialization

## Overview

This is a prompt-only skill for conducting structured personal SWOT analyses. It provides guided questions, visual matrix output, cross-quadrant strategies, and 90-day action plans.

**Time to initialize**: Instant — no setup needed.

## Package Contents

- `SKILL.md` — Complete skill with SWOT framework and action planning
- `INIT.md` — This initialization guide

## Directory Structure

```
personal-swot-analysis/
├── SKILL.md    # Main skill with framework and templates
└── INIT.md     # This file
```

## Dependencies

None — this is a prompt-only skill.

## Quick Start

### Claude / Claude Code
1. Open `SKILL.md`, copy content after frontmatter
2. Paste into a new conversation
3. Tell Claude about your career goal and current situation

### ChatGPT / Gemini / Copilot
Same process — paste and describe your career context.

## Core Capabilities

1. **Guided Discovery Questions** — Targeted questions for each SWOT quadrant
2. **Visual SWOT Matrix** — Clean 2x2 grid layout of findings
3. **Cross-Quadrant Strategies** — Leverage, defend, improve, avoid strategies
4. **90-Day Action Plan** — Monthly goals derived from SWOT insights
5. **Decision Scoring** — Apply SWOT to compare specific career options
6. **Pattern Recognition** — Common SWOT patterns and what they mean

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `goal` | `` | The career goal or decision you're working toward |
| `current_role` | `` | Your current job title or situation |
| `industry` | `` | Your industry or field |

## Usage Examples

### Example 1: Promotion Decision

**User:** "Should I push for promotion to manager or stay as a senior engineer?"

**AI Response:** Walks through SWOT for each path, creates comparison scoring, and recommends based on which option leverages more strengths and captures more opportunities.

### Example 2: Career Change

**User:** "I'm a teacher thinking about switching to corporate training."

**AI Response:** Identifies transferable strengths, skill gaps to address, market opportunities in L&D, and risks of career transition with a 90-day preparation plan.

### Example 3: Annual Self-Assessment

**User:** "I want to do a career check-in — been at the same company for 3 years."

**AI Response:** Full SWOT analysis revealing potential stagnation risks, untapped strengths, and growth opportunities within or outside the current role.

## Troubleshooting

| Issue | Solution |
|-------|----------|
| Can't identify strengths | Ask: "What do people always come to you for?" |
| Listing weaknesses feels bad | Reframe: These are "growth areas" — everyone has them |
| Can't see opportunities | Research your industry trends and company growth |
| Too many items per quadrant | Narrow to top 5 per quadrant — focus matters |
| Analysis feels abstract | Apply it to a specific decision using the scoring system |

## Best Practices

1. **Be brutally honest** — the analysis is only useful if it's truthful
2. **Ask someone else** — a trusted colleague or mentor can spot blind spots
3. **Focus on specifics** — "good communicator" is vague; "clear technical writer" is useful
4. **Review quarterly** — your SWOT changes as you grow
5. **Lead with strengths** — build your career around what you do well
6. **Address one weakness at a time** — trying to fix everything at once fixes nothing

---
Downloaded from [Find Skill.ai](https://findskill.ai)
