---
title: "Personal SWOT Analysis"
description: "Run a structured personal SWOT analysis to identify your strengths, weaknesses, opportunities, and threats. Make better career decisions with self-awareness."
platforms:
  - Claude
  - ChatGPT
  - Gemini
  - Copilot
difficulty: beginner
variables:
  - name: "goal"
    default: ""
    description: "The career goal or decision you're working toward"
  - name: "current_role"
    default: ""
    description: "Your current job title or situation"
  - name: "industry"
    default: ""
    description: "Your industry or field"
---

# Personal SWOT Analysis

A skill that guides you through a structured self-assessment using the SWOT framework (Strengths, Weaknesses, Opportunities, Threats). Turns vague self-perception into specific, actionable self-awareness with a 90-day action plan.

## When to Use This Skill

- Considering a career change or job switch
- Preparing for a promotion conversation
- Annual self-assessment or performance review
- Starting a job search and want to clarify your value
- Making a big decision between two career paths
- Feeling stuck and want to identify your next move

## The SWOT Framework

| Quadrant | Type | Question |
|----------|------|----------|
| Strengths | Internal, Positive | What do I do well? |
| Weaknesses | Internal, Negative | What could I improve? |
| Opportunities | External, Positive | What can I capitalize on? |
| Threats | External, Negative | What risks should I prepare for? |

## Key Features

- Guided discovery questions for each SWOT quadrant
- Visual SWOT matrix output
- Cross-quadrant strategies (S+O leverage, W+O improve, S+T defend, W+T avoid)
- 90-day action plan with monthly goals
- Decision scoring system for comparing options
- Common SWOT pattern recognition

---
Downloaded from [Find Skill.ai](https://findskill.ai)
