---
name: portfolio-fluff-cutter
version: 1.0.0
---

# Portfolio Fluff Cutter - Initialization

An AI-powered skill that evaluates developer portfolio projects and identifies which ones make you appear junior or inexperienced. Helps professionals curate portfolios by detecting weak projects that could damage first impressions with hiring managers.

## Package Contents

```
portfolio-fluff-cutter/
├── SKILL.md    # Main skill prompt (copy this to use)
└── INIT.md     # This initialization file
```

## Structure

- `SKILL.md` - The complete skill prompt with evaluation framework, scoring criteria, and output templates

## Files to Generate

None required. This is a prompt-only skill that works immediately when copied into any AI assistant.

## Quick Start

### Claude Code Users

```bash
# Copy skill to Claude Code skills directory
cp -r portfolio-fluff-cutter/ ~/.claude/skills/portfolio-fluff-cutter/
```

Then reference in your CLAUDE.md:
```markdown
## Available Skills

| Skill | Location | Use When |
|-------|----------|----------|
| `portfolio-fluff-cutter` | `~/.claude/skills/portfolio-fluff-cutter/` | Evaluating developer portfolios |
```

### ChatGPT / Claude.ai / Gemini Users

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into your AI assistant as a system prompt or at the start of conversation
4. Begin by sharing your portfolio projects

### Custom GPT / Claude Project Setup

1. Create a new Custom GPT or Claude Project
2. Paste the SKILL.md content as instructions
3. Add a starter prompt like: "I'll help you evaluate your portfolio. Share your projects!"

## Variables

Customize these when using the skill:

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_role}}` | `Junior Frontend Developer` | The role level and type you're targeting |
| `{{experience_years}}` | `2` | Years of development experience |
| `{{portfolio_projects}}` | (empty) | List of your current portfolio projects |
| `{{tech_stack}}` | `React, JavaScript, Node.js` | Your primary technologies |
| `{{authenticity_threshold}}` | `5` | Minimum score (1-10) for keeping a project |

## Example Usage

```
I have 6 projects in my portfolio:

1. A to-do list app with localStorage
2. A weather app fetching from OpenWeather API
3. My portfolio site itself
4. A React clone of Netflix UI (no real data)
5. An e-commerce site with Stripe integration
6. A personal blog with CMS

I learned most of these from YouTube tutorials. I want to apply for junior
front-end roles with 1.5 years of experience. Which projects should I remove
or significantly improve before sending to companies?
```

## Expected Output

The skill will provide:

1. **Overall Portfolio Health** assessment (Strong/Moderate/Weak)
2. **Per-Project Scores** across 7 criteria:
   - Authenticity (25% weight)
   - Code Quality (20% weight)
   - Problem-Solving (20% weight)
   - Polish (15% weight)
   - Deployment (10% weight)
   - Documentation (5% weight)
   - Career-Alignment (5% weight)
3. **Verdict per project**: KEEP / IMPROVE / REMOVE
4. **Portfolio Composition Analysis** (redundancy, diversity, narrative)
5. **Prioritized Action Plan** with specific next steps

## Key Concepts

- **Weakest Link Principle**: Your portfolio is judged by its worst project, not its best
- **Tutorial Clone Detection**: Identifies unmodified course/tutorial projects
- **Three Project Rule**: Quality over quantity - 3 strong > 8 mediocre
- **30-Second Test**: First impressions in initial hiring manager scan

## Who This Is For

- Early-career developers (1-3 years experience)
- Career changers with mixed-quality projects
- Self-taught developers with tutorial-heavy portfolios
- Bootcamp graduates
- Anyone preparing for job transitions

## Related Skills

- Resume & Job Search Coach
- ATS Resume Optimizer
- Interview Prep Simulator
- LinkedIn Profile Optimizer
- README Generator

---
Downloaded from [Find Skill.ai](https://findskill.ai)
