---
name: recruiter-ghosting-reply
version: 1.0.0
---

# Initialization

Recruiter Ghosting Reply is a psychology-backed AI skill for crafting follow-up emails that break through recruiter silence. It uses proven cognitive triggers (reciprocity, curiosity gaps, loss aversion), optimal timing strategies, and multi-email sequences to help job seekers get responses after interviews.

## Structure

- `SKILL.md` - Main skill prompt with complete instructions

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r recruiter-ghosting-reply/ ~/.claude/skills/recruiter-ghosting-reply/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (everything below the second `---`)
3. Paste into AI assistant as system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{days_since_interview}}` | `7` | Days since last communication with recruiter |
| `{{interview_stage}}` | `first_round` | Level: initial_screen, first_round, second_round, final |
| `{{promised_timeline}}` | `end_of_week` | What recruiter said about response timing |
| `{{relationship_strength}}` | `medium` | Connection level: weak, medium, strong |
| `{{multi_channel_enabled}}` | `false` | Whether to use LinkedIn/phone in addition to email |

## Example Usage

```
I interviewed with the marketing director at TechCorp on Tuesday about
the Product Manager role. They said they'd get back to me by Friday but
it's now 5 days later and complete radio silence. I want to follow up
without looking desperate. Help me write an email that gets a response.
```

## Key Features

- **Timing Intelligence**: Optimal follow-up timing by interview stage
- **Psychological Triggers**: Reciprocity, curiosity gaps, loss aversion
- **Subject Line Generation**: Pattern interruption, curiosity, personalization
- **Email Sequences**: 3-email escalation strategy
- **Channel Selection**: Email vs LinkedIn vs phone guidance
- **Template Library**: 5 ready-to-customize templates

## Quick Reference: Timing

| Stage | First Follow-up | Second Follow-up |
|-------|-----------------|------------------|
| Application | 3-5 days | +5-7 days |
| Phone screen | 5-7 days | Day 9-10 |
| First round | 5-7 days past deadline | Day 12-14 |
| Final round | 5-7 days past deadline | Day 10-12 |

## Quick Reference: Response Rates

| Email Type | Expected Response |
|------------|-------------------|
| First follow-up | 25-40% |
| Value-add email | +12-15% |
| Breakup email | +5-8% |
| With internal referral | 60-75% |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
