---
name: remote-work-visibility-booster
version: 1.0.0
---

# Initialization

Remote Work Visibility Booster - Combat proximity bias and stay top-of-mind for promotions while working remotely. This skill helps professionals build visibility rituals, document achievements systematically, and cultivate decision-maker relationships.

## Structure

- `SKILL.md` - Main skill prompt with visibility strategies, templates, and workflows

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r remote-work-visibility-booster/ ~/.claude/skills/remote-work-visibility-booster/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter
3. Paste into AI assistant

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{visibility_update_frequency}}` | `weekly` | How often to send status updates to manager |
| `{{cross_team_projects_per_year}}` | `2` | Target high-visibility projects to pursue annually |
| `{{decision_maker_network_size}}` | `10` | Target decision-makers to cultivate relationships with |
| `{{achievement_review_cadence}}` | `monthly` | How often to review achievements with manager |
| `{{peer_feedback_sources}}` | `4` | Peer relationships to cultivate for feedback |
| `{{skip_level_touchpoint_frequency}}` | `quarterly` | How often to schedule skip-level touchpoints |

## Key Capabilities

1. **Visibility Assessment** - Audit current visibility risk level and identify gaps
2. **Weekly Ritual System** - Establish consistent manager communication patterns
3. **Achievement Documentation** - Track and organize accomplishments for review cycles
4. **Cross-Team Positioning** - Identify and pursue high-visibility project opportunities
5. **Relationship Mapping** - Build network of decision-maker advocates
6. **Communication Templates** - Ready-to-use emails for updates, recaps, and outreach
7. **Promotion Preparation** - Timeline and strategy for upcoming review cycles

## Recommended Usage

**First Session:**
- Share your work arrangement (remote/hybrid/flexible)
- Describe your team and manager's arrangement
- Explain your career goals and timeline
- Let the skill assess your visibility risk level

**Ongoing Sessions:**
- Review progress on visibility habits
- Troubleshoot challenges
- Prepare for specific events (reviews, promotions)
- Conduct quarterly visibility audits

---
Downloaded from [Find Skill.ai](https://findskill.ai)
