---
name: salary-expectations-script
version: 1.0.0
---

# Initialization

A salary negotiation strategist skill that provides tactical, research-backed scripts for responding to "What are your salary expectations?" during job interviews. Maximizes compensation while maintaining professional relationships through deferral strategies, counter-questions, and negotiation frameworks.

## Structure

- `SKILL.md` - Main skill prompt with response frameworks, workflows, and scripts

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r salary-expectations-script/ ~/.claude/skills/salary-expectations-script/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are a salary negotiation strategist...")
3. Paste into AI assistant as system prompt or conversation starter

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{current_salary}}` | `Not disclosed` | Your current compensation (keep private) |
| `{{target_range_low}}` | `Based on market research` | Lower bound of salary range |
| `{{target_range_high}}` | `Based on market research` | Upper bound (15-20% spread) |
| `{{interview_stage}}` | `phone_screen` | Stage: phone_screen, first_round, final_round, post_offer |
| `{{leverage_score}}` | `5` | Negotiating power 1-10 |
| `{{industry}}` | `technology` | Industry: tech, finance, healthcare, nonprofit, consulting |

## Key Features

### Response Frameworks
1. **The Deferral** - Postpone salary discussion to learn more
2. **The Counter-Question** - Flip anchoring by asking their budget first
3. **The Research-Backed Range** - Provide justified range with flexibility
4. **The Leverage Play** - Use competing offers strategically
5. **The Pivot to Total Comp** - Negotiate beyond base salary

### Workflows Included
- Phone Screen Response (4-step process)
- Post-Offer Negotiation (6-step process)
- Handling Objections (common responses)
- Industry-Specific Guidance (tech, finance, healthcare, nonprofit, consulting)

### Scripts for Scenarios
- Career changer / entry level
- Re-entering workforce
- Competing offers
- Internal promotion
- Remote role with location-based pay

## Usage Example

**User prompt:**
```
I'm in a phone screen for a Senior Product Manager role at a Series C startup in Austin.
They just asked "What are your salary expectations?"

Context:
- I currently make $145K
- Market rate is $160K-$190K based on Levels.fyi
- I have another interview next week
- 7 years of PM experience

Give me the exact script to respond.
```

**AI will provide:**
- Situation analysis with leverage score
- Recommended strategy (defer vs. range)
- Exact script to use
- Counter-scripts for pushback
- Red flags to watch for
- Next steps

## Research Sources

- SHRM Compensation Guide (shrm.org)
- Levels.fyi Tech Compensation Database
- Glassdoor Salary Research
- Harvard Negotiation Essentials
- PayScale Market Data
- LinkedIn Salary Tool
- Reddit r/cscareerquestions real negotiations

---

Downloaded from [Find Skill.ai](https://findskill.ai)
