---
name: salary-inflation-adjuster
version: 1.0.0
---

# Salary Inflation Adjuster - Initialization

Calculate purchasing power loss since your last raise using official CPI data, then generate a professional, data-driven script to request a cost-of-living adjustment.

## What This Skill Does

This skill transforms raw inflation economics into actionable salary negotiation language. It uses official Consumer Price Index (CPI) data from government sources to calculate exactly how much purchasing power you've lost since your last raise, then generates professional scripts for requesting a cost-of-living adjustment.

**Key capabilities:**
- CPI-based inflation calculation using official government data
- Purchasing power loss quantification in real currency terms
- Professional negotiation script generation
- Multi-country support (US, Canada, UK, Australia)
- Objection handling for common manager responses

## Structure

```
salary-inflation-adjuster/
├── SKILL.md    # Main skill prompt (copy this to your AI assistant)
└── INIT.md     # This initialization file
```

## Files to Generate

None (prompt-only skill)

## Installation

### Claude Code / Claude Desktop

```bash
# Copy the skill folder to your Claude skills directory
cp -r salary-inflation-adjuster/ ~/.claude/skills/salary-inflation-adjuster/
```

Then reference in your CLAUDE.md:
```markdown
## Skills
- salary-inflation-adjuster: Calculate inflation-adjusted raise requests
```

### ChatGPT / Custom GPT

1. Open `SKILL.md`
2. Copy all content after the frontmatter (after the second `---`)
3. Paste into ChatGPT as a system prompt or Custom GPT instructions

### Other AI Assistants (Gemini, Copilot, etc.)

1. Open `SKILL.md`
2. Copy the full prompt content
3. Paste into your AI assistant's system/custom instructions

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `current_salary` | `60000` | Annual salary in local currency |
| `last_raise_date` | `2023-12-01` | Date of last salary review (YYYY-MM-DD) |
| `today_date` | `2024-12-18` | Current or target negotiation date |
| `country_code` | `US` | Country for CPI source (US, CA, UK, AU) |
| `currency` | `USD` | Currency symbol for display |
| `inflation_data_source` | `BLS` | Data source: BLS, StatsCan, ONS, ABS |

## Quick Start Example

After installation, try this prompt:

```
I make $75,000/year. My last raise was December 15, 2023.
I have my annual review next week. What raise should I
request to maintain my purchasing power, and can you give
me a professional script to present this to my manager?
```

Expected output:
- Inflation percentage since last raise
- Purchasing power loss in dollars
- Required raise percentage and amount
- Professional negotiation script
- Objection handling responses

## Data Sources

The skill references official government inflation data:

| Country | Source | URL |
|---------|--------|-----|
| US | Bureau of Labor Statistics | https://www.bls.gov/cpi/ |
| Canada | Statistics Canada | https://www.statcan.gc.ca |
| UK | Office for National Statistics | https://www.ons.gov.uk |
| Australia | Australian Bureau of Statistics | https://www.abs.gov.au |

## Use Cases

1. **Annual Review Preparation**: Calculate COLA before performance review
2. **Job Offer Evaluation**: Compare new offer to inflation-adjusted current salary
3. **Freelancer Rate Updates**: Justify rate increases to long-term clients
4. **Multi-Year Analysis**: Track purchasing power trajectory over career
5. **Team Equity Analysis**: For managers reviewing team compensation

## Core Formula Reference

```
Inflation Rate = ((CPI_Current - CPI_Base) / CPI_Base) × 100
Purchasing Power Loss = Salary × (1 - (CPI_Base / CPI_Current))
Required Salary = Salary × (CPI_Current / CPI_Base)
```

## Tips for Best Results

1. **Be specific**: Include exact salary, dates, and country
2. **Use recent data**: CPI is released ~12 days after month end
3. **Practice scripts**: Read the generated scripts out loud before meetings
4. **Separate concerns**: Keep COLA separate from merit/promotion discussions
5. **Document everything**: Save the analysis for future reference

---
Downloaded from [Find Skill.ai](https://findskill.ai)
