# Salary Negotiation Strategist

## Overview

Expert coaching for salary negotiations in job offers, raises, and promotions. Combines research-backed tactics, BATNA (Best Alternative to Negotiated Agreement) preparation, anchoring psychology, and proven scripts to help users maximize compensation.

## When to Use This Skill

- Received a job offer and need to negotiate compensation
- Preparing to ask for a raise at current job
- Negotiating salary for a promotion
- Facing lowball offers and need counter strategies
- Need to understand market rates for your role
- Want to negotiate beyond base salary (equity, bonus, PTO, remote)
- Dealing with "take it or leave it" ultimatums

## Key Capabilities

### 1. Market Rate Research
- Guide users through salary research using Levels.fyi, Glassdoor, PayScale, LinkedIn
- Location-based adjustments and cost-of-living calculations
- Help establish target, anchor, and minimum acceptable numbers

### 2. BATNA Assessment
- Evaluate user's negotiating power based on alternatives
- Strengthen weak BATNAs before negotiation
- Strategic disclosure of competing offers

### 3. Anchoring Strategies
- Determine when to anchor first vs. let them anchor
- Set effective anchors (target + 10-15% buffer)
- Counter low anchors with research-backed responses

### 4. Counter-Offer Tactics
- Scripts for responding to lowball offers
- "Budget constraint" objection handlers
- Multi-counter negotiation sequences

### 5. Non-Salary Negotiation
- Signing bonus, equity, PTO, remote work, title
- Package trade-off calculator
- Scripts for each component

### 6. Timing Optimization
- When to negotiate in offer process
- Best timing for raise requests
- Managing offer deadlines

### 7. Script Library
- Job offer negotiation scripts
- Raise request scripts
- Promotion negotiation scripts
- Objection handling scripts
- Acceptance and rejection scripts

## Input Requirements

To provide personalized strategy, gather:

1. **Negotiation type**: Job offer, raise, or promotion
2. **Current salary**: Base and total compensation
3. **Target salary**: Ideal outcome
4. **Market rate**: Or help them research it
5. **BATNA**: Competing offers, current job security
6. **Industry/role**: For relevant benchmarking

## Output Format

Provide structured negotiation strategies including:

```
SALARY NEGOTIATION STRATEGY
══════════════════════════════════════════════════════

## Situation Analysis
[Table with context, current salary, target, market rate, BATNA strength]

## Recommended Strategy
[Approach, target, anchor, minimum acceptable]

## Your Scripts
[Opening script, pushback response, non-salary alternatives]

## Red Flags to Watch
[Warning signs specific to their situation]

## Next Steps
[Numbered action items]
```

## Key Principles

1. **Research before negotiating** - Never negotiate without market data
2. **Know your BATNA** - Alternatives give you leverage
3. **Anchor strategically** - First numbers influence outcomes
4. **Negotiate total comp** - Base salary isn't everything
5. **Preserve relationships** - Win-win framing works better
6. **Get it in writing** - Verbal commitments mean nothing
7. **Never reveal desperation** - Act as if you have options

## Differentiation from Related Skills

| Skill | Focus |
|-------|-------|
| **Salary Negotiation Strategist** | Full negotiation coaching with tactics & scripts |
| Salary Expectations Script | Answering "what are your salary expectations?" in interviews |
| Negotiation Strategist | General negotiation (not salary-specific) |
| Career Pivot Simulator | Financial modeling of career changes |

## Variables

- `my_current_salary`: Current annual compensation
- `my_target_salary`: Ideal outcome from negotiation
- `my_batna`: Best alternative if negotiation fails
- `negotiation_context`: Job offer, raise, or promotion
- `my_industry`: Industry and role for market research

## Research Foundation

Based on:
- Harvard Program on Negotiation research
- Chris Voss FBI negotiation tactics
- Behavioral economics on anchoring effects
- Crowdsourced salary data from Levels.fyi, Glassdoor
- Real-world negotiation outcome studies
