---
name: self-directed-learning-journey
version: 1.0.0
---

# Initialization

Self-Directed Learning Journey - Design your own 3-12 month learning roadmap with built-in accountability, progress tracking, and mastery verification for career transitions and skill acquisition.

## Structure

- `SKILL.md` - Main skill prompt with complete learning journey framework

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r self-directed-learning-journey/ ~/.claude/skills/self-directed-learning-journey/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "You are an expert...")
3. Paste into your AI assistant's custom instructions or as a system prompt

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{target_skill}}` | `Web Development` | The primary skill, domain, or subject you want to master |
| `{{current_proficiency}}` | `beginner` | Your current competency level (beginner, intermediate, advanced) |
| `{{total_journey_hours}}` | `200` | Total hours you can invest in the complete learning journey |
| `{{weekly_hours}}` | `10` | Hours per week you can consistently dedicate to learning |
| `{{learning_preference}}` | `mixed` | Preferred content formats (visual, auditory, kinesthetic, reading-writing, mixed) |
| `{{accountability_style}}` | `weekly-review` | How you prefer to be held accountable (self-check, weekly-review, milestone-gates, strict-mastery) |

## Usage Examples

### Career Transition
```
I want to transition from marketing into UX Design over the next 4 months.
I can dedicate 15 hours per week. I have no formal design training but
strong research and communication skills. I learn best through hands-on
projects and visual examples. Create my self-directed learning journey
with weekly milestones and specific free resources.
```

### Technical Upskilling
```
I'm a Python developer wanting to learn machine learning. I code daily
and understand statistics basics. I have 5 hours/week available.
Timeline is flexible but I'd like to reach job-ready competency in
6 months. Create my learning journey with coding-heavy curriculum.
```

### Language Learning
```
I want to learn Spanish from zero to conversational fluency. I'm in
school and have 1.5 hours daily for studying. I get distracted easily
so I need short, engaging sessions. My goal is travel-ready Spanish
in 1 year. Design my journey with daily micro-lessons.
```

## Key Features

1. **Four-Phase Framework**: Foundation (15-20%) → Skill Building (40-50%) → Integration (20-25%) → Mastery (10-15%)

2. **Personalized Assessment**: Comprehensive discovery questions covering learning target, current state, constraints, preferences, and application context

3. **Adaptive Progress Monitoring**: Performance-based triggers for acceleration, maintenance, or remediation

4. **Built-in Accountability**: Four styles (self-check, weekly-review, milestone-gates, strict-mastery) matched to learner preference

5. **Troubleshooting Guide**: Common issues with diagnosis and solutions for stuck learners

## Differentiation from Similar Skills

| Skill | Focus | Duration | Target User |
|-------|-------|----------|-------------|
| **This Skill** | Self-directed individual learning | 3-12 months | Career changers, self-learners |
| Learning Path Designer | L&D curriculum design | Variable | Educators, L&D professionals |
| 30-Day Skill Mastery | Intensive skill acquisition | 30 days | Quick learners |
| Skill Gap Analyzer | Gap identification | Analysis only | Career planners |

---
Downloaded from [Find Skill.ai](https://findskill.ai)
