---
name: skill-transferability-mapper
version: 1.0.0
---

# Initialization

Career transition mapping tool for teachers, nurses, and healthcare professionals seeking corporate roles. Maps soft skills to specific corporate positions using O*NET occupational data, provides resume translation, and creates 12-month transition roadmaps.

## Structure

- `SKILL.md` - Main skill prompt with 5 workflows (discovery, role matching, gap analysis, resume translation, interview prep)

## Files to Generate

None (prompt-only skill)

## Post-Init Steps

### Claude Code
```bash
cp -r skill-transferability-mapper/ ~/.claude/skills/skill-transferability-mapper/
```

### Other AI Assistants
1. Open `SKILL.md`
2. Copy content after frontmatter (starting from "# SKILL TRANSFERABILITY MAPPER")
3. Paste into AI assistant as system prompt or initial message

## Variables

| Variable | Default | Description |
|----------|---------|-------------|
| `{{source_profession}}` | `teacher` | Current profession (teacher, nurse, healthcare_provider, educator) |
| `{{years_experience}}` | `10` | Total years in current profession |
| `{{soft_skill_profile}}` | `communication, leadership, time_management, critical_thinking, adaptability, crisis_management` | Strongest soft skills (comma-separated) |
| `{{target_industry}}` | `technology` | Preferred corporate industry |
| `{{time_to_transition}}` | `12` | Months available for transition (3-24) |
| `{{role_seniority_preference}}` | `coordinator_to_manager` | Target level (entry_coordinator, coordinator_to_manager, senior_manager) |

## Example Prompts

### Teacher Seeking First Corporate Role
```
I've been a high school English teacher for 12 years managing classes of 25-30
students. I'm strong at curriculum design, stakeholder management with parents/admin,
and adapting to difficult situations. I want to move into corporate training or
project management. What roles should I target, and what hard skills do I need
to focus on in the next 12 months?
```

### Nurse Transitioning to Healthcare Operations
```
I'm an RN with 15 years in emergency nursing. I'm excellent at crisis management,
communicating with diverse teams, managing competing priorities under pressure,
and making quick decisions with incomplete information. I'm considering leaving
bedside care for corporate healthcare operations or pharmaceutical company roles.
What are my options?
```

### Resume Translation Request
```
Here's my teaching resume. Can you help me translate it for corporate project
management roles? I want each bullet point reframed in corporate language with
metrics where possible.
```

## Key Features

1. **Soft Skill Profiling** - Guided interview to identify and validate transferable competencies
2. **Role Discovery** - Match skills to 15-20 corporate positions with salary and demand data
3. **Gap Analysis** - Compare user profile against job requirements, identify learning needs
4. **Resume Translation** - Convert education/healthcare experience to corporate language
5. **Interview Prep** - Behavioral questions, STAR examples, objection handlers

## Target Audience

- Teachers (K-12, higher education) seeking corporate roles
- Nurses and healthcare professionals transitioning to operations
- Career counselors helping education/healthcare professionals pivot
- HR professionals evaluating career changer candidates

## Best-Fit Corporate Roles

**For Teachers:**
- Instructional Designer
- L&D Coordinator/Specialist
- Program Manager
- Corporate Trainer
- Project Coordinator
- Customer Success Manager

**For Nurses:**
- Program Manager (Healthcare Operations)
- Quality Assurance Manager
- Operations Coordinator (Pharmaceutical)
- Medical Liaison
- Clinical Program Manager
- Compliance Coordinator

---
Downloaded from [Find Skill.ai](https://findskill.ai)
